/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache;

import java.time.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(prefix="spring.cloud.gateway.server.webflux.filter.local-response-cache")
public class LocalResponseCacheProperties {
    static final String PREFIX = "spring.cloud.gateway.server.webflux.filter.local-response-cache";
    private static final Log LOGGER = LogFactory.getLog(LocalResponseCacheProperties.class);
    private static final Duration DEFAULT_CACHE_TTL_MINUTES = Duration.ofMinutes(5L);
    private @Nullable DataSize size;
    private @Nullable Duration timeToLive;
    private RequestOptions request = new RequestOptions();

    public @Nullable DataSize getSize() {
        return this.size;
    }

    public void setSize(DataSize size) {
        this.size = size;
    }

    public Duration getTimeToLive() {
        if (this.timeToLive == null) {
            LOGGER.debug((Object)String.format("No TTL configuration found. Default TTL will be applied for cache entries: %s minutes", DEFAULT_CACHE_TTL_MINUTES));
            return DEFAULT_CACHE_TTL_MINUTES;
        }
        return this.timeToLive;
    }

    public void setTimeToLive(Duration timeToLive) {
        this.timeToLive = timeToLive;
    }

    public RequestOptions getRequest() {
        return this.request;
    }

    public void setRequest(RequestOptions request) {
        this.request = request;
    }

    public String toString() {
        return "LocalResponseCacheProperties{size=" + String.valueOf(this.size) + ", timeToLive=" + String.valueOf(this.timeToLive) + ", request=" + String.valueOf(this.request) + "}";
    }

    public static class RequestOptions {
        private NoCacheStrategy noCacheStrategy = NoCacheStrategy.SKIP_UPDATE_CACHE_ENTRY;

        public NoCacheStrategy getNoCacheStrategy() {
            return this.noCacheStrategy;
        }

        public void setNoCacheStrategy(NoCacheStrategy noCacheStrategy) {
            this.noCacheStrategy = noCacheStrategy;
        }

        public String toString() {
            return "RequestOptions{noCacheStrategy=" + String.valueOf((Object)this.noCacheStrategy) + "}";
        }
    }

    public static enum NoCacheStrategy {
        UPDATE_CACHE_ENTRY,
        SKIP_UPDATE_CACHE_ENTRY;

    }
}

