/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.discovery;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.gateway.discovery.DiscoveryLocatorProperties;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.core.style.ToStringCreator;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public class DiscoveryClientRouteDefinitionLocator
implements RouteDefinitionLocator {
    private static final Log log = LogFactory.getLog(DiscoveryClientRouteDefinitionLocator.class);
    private final DiscoveryLocatorProperties properties;
    private final String routeIdPrefix;
    private final SimpleEvaluationContext evalCtxt;
    private @Nullable Flux<List<ServiceInstance>> serviceInstances;

    public DiscoveryClientRouteDefinitionLocator(ReactiveDiscoveryClient discoveryClient, DiscoveryLocatorProperties properties) {
        this(discoveryClient.getClass().getSimpleName(), properties);
        this.serviceInstances = discoveryClient.getServices().flatMap(service -> discoveryClient.getInstances(service).collectList());
    }

    private DiscoveryClientRouteDefinitionLocator(String discoveryClientName, DiscoveryLocatorProperties properties) {
        this.properties = properties;
        this.routeIdPrefix = StringUtils.hasText((String)properties.getRouteIdPrefix()) ? properties.getRouteIdPrefix() : discoveryClientName + "_";
        this.evalCtxt = SimpleEvaluationContext.forReadOnlyDataBinding().withInstanceMethods().build();
    }

    @Override
    public Flux<RouteDefinition> getRouteDefinitions() {
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression includeExpr = parser.parseExpression(this.properties.getIncludeExpression());
        Expression urlExpr = parser.parseExpression(this.properties.getUrlExpression());
        Predicate<ServiceInstance> includePredicate = this.properties.getIncludeExpression() == null || "true".equalsIgnoreCase(this.properties.getIncludeExpression()) ? instance -> true : instance -> {
            Boolean include = (Boolean)includeExpr.getValue((EvaluationContext)this.evalCtxt, instance, Boolean.class);
            if (include == null) {
                return false;
            }
            return include;
        };
        Objects.requireNonNull(this.serviceInstances, "serviceInstances must be set");
        return this.serviceInstances.filter(instances -> !instances.isEmpty()).flatMap(Flux::fromIterable).filter(includePredicate).collectMap(instance -> instance.getServiceId()).flatMapMany(map -> Flux.fromIterable(map.values())).map(instance -> {
            String value;
            RouteDefinition routeDefinition = this.buildRouteDefinition(urlExpr, (ServiceInstance)instance);
            DelegatingServiceInstance instanceForEval = new DelegatingServiceInstance((ServiceInstance)instance, this.properties);
            for (PredicateDefinition predicateDefinition : this.properties.getPredicates()) {
                PredicateDefinition predicate = new PredicateDefinition();
                if (predicateDefinition.getName() != null) {
                    predicate.setName(predicateDefinition.getName());
                }
                for (Map.Entry<String, String> entry : predicateDefinition.getArgs().entrySet()) {
                    value = this.getValueFromExpr(this.evalCtxt, parser, instanceForEval, entry);
                    if (value == null) continue;
                    predicate.addArg(entry.getKey(), value);
                }
                routeDefinition.getPredicates().add(predicate);
            }
            for (FilterDefinition filterDefinition : this.properties.getFilters()) {
                FilterDefinition filter = new FilterDefinition();
                if (filterDefinition.getName() != null) {
                    filter.setName(filterDefinition.getName());
                }
                for (Map.Entry<String, String> entry : filterDefinition.getArgs().entrySet()) {
                    value = this.getValueFromExpr(this.evalCtxt, parser, instanceForEval, entry);
                    if (value == null) continue;
                    filter.addArg(entry.getKey(), value);
                }
                routeDefinition.getFilters().add(filter);
            }
            return routeDefinition;
        });
    }

    protected RouteDefinition buildRouteDefinition(Expression urlExpr, ServiceInstance serviceInstance) {
        String serviceId = serviceInstance.getServiceId();
        RouteDefinition routeDefinition = new RouteDefinition();
        routeDefinition.setId(this.routeIdPrefix + serviceId);
        String uri = (String)urlExpr.getValue((EvaluationContext)this.evalCtxt, (Object)serviceInstance, String.class);
        if (uri != null) {
            routeDefinition.setUri(URI.create(uri));
        }
        routeDefinition.setMetadata(new LinkedHashMap<String, Object>(serviceInstance.getMetadata()));
        return routeDefinition;
    }

    private @Nullable String getValueFromExpr(SimpleEvaluationContext evalCtxt, SpelExpressionParser parser, ServiceInstance instance, Map.Entry<String, String> entry) {
        try {
            Expression valueExpr = parser.parseExpression(entry.getValue());
            return (String)valueExpr.getValue((EvaluationContext)evalCtxt, (Object)instance, String.class);
        }
        catch (EvaluationException | ParseException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to parse " + entry.getValue()), e);
            }
            throw e;
        }
    }

    private static class DelegatingServiceInstance
    implements ServiceInstance {
        final ServiceInstance delegate;
        private final DiscoveryLocatorProperties properties;

        private DelegatingServiceInstance(ServiceInstance delegate, DiscoveryLocatorProperties properties) {
            this.delegate = delegate;
            this.properties = properties;
        }

        public String getServiceId() {
            if (this.properties.isLowerCaseServiceId()) {
                return this.delegate.getServiceId().toLowerCase(Locale.ROOT);
            }
            return this.delegate.getServiceId();
        }

        public String getHost() {
            return this.delegate.getHost();
        }

        public int getPort() {
            return this.delegate.getPort();
        }

        public boolean isSecure() {
            return this.delegate.isSecure();
        }

        public URI getUri() {
            return this.delegate.getUri();
        }

        public @Nullable Map<String, String> getMetadata() {
            return this.delegate.getMetadata();
        }

        public @Nullable String getScheme() {
            return this.delegate.getScheme();
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("delegate", (Object)this.delegate).append("properties", (Object)this.properties).toString();
        }
    }
}

