/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.ratelimit;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BandwidthBuilder;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.distributed.AsyncBucketProxy;
import io.github.bucket4j.distributed.proxy.AsyncProxyManager;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.filter.ratelimit.AbstractRateLimiter;
import org.springframework.cloud.gateway.filter.ratelimit.RateLimiter;
import org.springframework.cloud.gateway.support.ConfigurationService;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class Bucket4jRateLimiter
extends AbstractRateLimiter<Config> {
    public static final String DEFAULT_HEADER_NAME = "X-RateLimit-Remaining";
    public static final String CONFIGURATION_PROPERTY_NAME = "bucket4j-rate-limiter";
    private final Log log = LogFactory.getLog(this.getClass());
    private final AsyncProxyManager<String> proxyManager;
    private Config defaultConfig = new Config();

    public Bucket4jRateLimiter(AsyncProxyManager<String> proxyManager, ConfigurationService configurationService) {
        super(Config.class, CONFIGURATION_PROPERTY_NAME, configurationService);
        this.proxyManager = proxyManager;
    }

    @Override
    public Mono<RateLimiter.Response> isAllowed(String routeId, String id) {
        Config routeConfig = this.loadRouteConfiguration(routeId);
        AsyncBucketProxy bucket = this.proxyManager.builder().build((Object)id, routeConfig.getConfigurationSupplier());
        CompletableFuture bucketFuture = bucket.tryConsumeAndReturnRemaining(routeConfig.getRequestedTokens());
        return Mono.fromFuture((CompletableFuture)bucketFuture).onErrorResume(throwable -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Error calling Bucket4J rate limiter", throwable);
            }
            return Mono.just((Object)ConsumptionProbe.rejected((long)-1L, (long)-1L, (long)-1L));
        }).map(consumptionProbe -> {
            boolean allowed = consumptionProbe.isConsumed();
            long remainingTokens = consumptionProbe.getRemainingTokens();
            RateLimiter.Response response = new RateLimiter.Response(allowed, this.getHeaders(routeConfig, remainingTokens));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("response: " + String.valueOf(response)));
            }
            return response;
        });
    }

    protected Config loadRouteConfiguration(String routeId) {
        Config routeConfig = this.getConfig().getOrDefault(routeId, this.defaultConfig);
        if (routeConfig == null) {
            routeConfig = (Config)this.getConfig().get("defaultFilters");
        }
        if (routeConfig == null) {
            throw new IllegalArgumentException("No Configuration found for route " + routeId + " or defaultFilters");
        }
        return routeConfig;
    }

    public Map<String, String> getHeaders(Config config, Long tokensLeft) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(config.getHeaderName(), tokensLeft.toString());
        return headers;
    }

    public static class Config {
        private static final Function<Config, BucketConfiguration> DEFAULT_CONFIGURATION_BUILDER = config -> {
            BandwidthBuilder.BandwidthBuilderRefillStage bandwidth = Bandwidth.builder().capacity(config.getCapacity());
            long refillTokens = config.getRefillTokens() == null ? config.getCapacity() : config.getRefillTokens().longValue();
            BandwidthBuilder.BandwidthBuilderBuildStage refill = switch (config.getRefillStyle().ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> bandwidth.refillGreedy(refillTokens, config.getRefillPeriod());
                case 1 -> bandwidth.refillIntervally(refillTokens, config.getRefillPeriod());
                case 2 -> bandwidth.refillIntervallyAligned(refillTokens, config.getRefillPeriod(), config.getTimeOfFirstRefill());
            };
            return BucketConfiguration.builder().addLimit(refill.build()).build();
        };
        long capacity;
        Function<Config, BucketConfiguration> configurationBuilder = DEFAULT_CONFIGURATION_BUILDER;
        Supplier<CompletableFuture<BucketConfiguration>> configurationSupplier;
        String headerName = "X-RateLimit-Remaining";
        Duration refillPeriod;
        RefillStyle refillStyle = RefillStyle.GREEDY;
        Long refillTokens;
        long requestedTokens = 1L;
        Instant timeOfFirstRefill;

        public long getCapacity() {
            return this.capacity;
        }

        public Config setCapacity(long capacity) {
            this.capacity = capacity;
            return this;
        }

        public Function<Config, BucketConfiguration> getConfigurationBuilder() {
            return this.configurationBuilder;
        }

        public void setConfigurationBuilder(Function<Config, BucketConfiguration> configurationBuilder) {
            Assert.notNull(configurationBuilder, (String)"configurationBuilder may not be null");
            this.configurationBuilder = configurationBuilder;
        }

        public Supplier<CompletableFuture<BucketConfiguration>> getConfigurationSupplier() {
            if (this.configurationSupplier != null) {
                return this.configurationSupplier;
            }
            return () -> CompletableFuture.completedFuture(this.getConfigurationBuilder().apply(this));
        }

        public void setConfigurationSupplier(Function<Config, BucketConfiguration> configurationBuilder) {
            Assert.notNull(configurationBuilder, (String)"configurationBuilder may not be null");
            this.configurationBuilder = configurationBuilder;
        }

        public String getHeaderName() {
            return this.headerName;
        }

        public Config setHeaderName(String headerName) {
            Assert.notNull((Object)headerName, (String)"headerName may not be null");
            this.headerName = headerName;
            return this;
        }

        public Duration getRefillPeriod() {
            return this.refillPeriod;
        }

        public Config setRefillPeriod(Duration refillPeriod) {
            this.refillPeriod = refillPeriod;
            return this;
        }

        public RefillStyle getRefillStyle() {
            return this.refillStyle;
        }

        public Config setRefillStyle(RefillStyle refillStyle) {
            this.refillStyle = refillStyle;
            return this;
        }

        public Long getRefillTokens() {
            return this.refillTokens;
        }

        public Config setRefillTokens(Long refillTokens) {
            this.refillTokens = refillTokens;
            return this;
        }

        public long getRequestedTokens() {
            return this.requestedTokens;
        }

        public Config setRequestedTokens(long requestedTokens) {
            this.requestedTokens = requestedTokens;
            return this;
        }

        public Instant getTimeOfFirstRefill() {
            return this.timeOfFirstRefill;
        }

        public Config setTimeOfFirstRefill(Instant timeOfFirstRefill) {
            this.timeOfFirstRefill = timeOfFirstRefill;
            return this;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("capacity", this.capacity).append("headerName", (Object)this.headerName).append("refillPeriod", (Object)this.refillPeriod).append("refillStyle", (Object)this.refillStyle).append("refillTokens", (Object)this.refillTokens).append("requestedTokens", this.requestedTokens).append("timeOfFirstRefill", (Object)this.timeOfFirstRefill).toString();
        }
    }

    public static enum RefillStyle {
        GREEDY,
        INTERVALLY,
        INTERVALLY_ALIGNED;

    }
}

