/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache.postprocessor;

import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.gateway.filter.factory.cache.CachedResponse;
import org.springframework.cloud.gateway.filter.factory.cache.LocalResponseCacheUtils;
import org.springframework.cloud.gateway.filter.factory.cache.postprocessor.AfterCacheExchangeMutator;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;

public class SetMaxAgeHeaderAfterCacheExchangeMutator
implements AfterCacheExchangeMutator {
    private static final String MAX_AGE_PREFIX = "max-age=";
    private final Duration configuredTimeToLive;
    private final Clock clock;
    private final boolean ignoreNoCacheUpdate;

    public SetMaxAgeHeaderAfterCacheExchangeMutator(Duration configuredTimeToLive, Clock clock, boolean ignoreNoCacheUpdate) {
        this.configuredTimeToLive = configuredTimeToLive;
        this.clock = clock;
        this.ignoreNoCacheUpdate = ignoreNoCacheUpdate;
    }

    @Override
    public void accept(ServerWebExchange exchange, CachedResponse cachedResponse) {
        ServerHttpResponse response = exchange.getResponse();
        long calculatedMaxAgeInSeconds = this.calculateMaxAgeInSeconds(exchange.getRequest(), cachedResponse, this.configuredTimeToLive);
        SetMaxAgeHeaderAfterCacheExchangeMutator.rewriteCacheControlMaxAge(response.getHeaders(), calculatedMaxAgeInSeconds);
    }

    private long calculateMaxAgeInSeconds(ServerHttpRequest request, CachedResponse cachedResponse, Duration configuredTimeToLive) {
        long maxAge;
        boolean noCache = LocalResponseCacheUtils.isNoCacheRequest(request);
        if (noCache && this.ignoreNoCacheUpdate || configuredTimeToLive.getSeconds() < 0L) {
            maxAge = 0L;
        } else {
            long calculatedMaxAge = configuredTimeToLive.minus(this.getElapsedTimeInSeconds(cachedResponse)).getSeconds();
            maxAge = Math.max(0L, calculatedMaxAge);
        }
        return maxAge;
    }

    private Duration getElapsedTimeInSeconds(CachedResponse cachedResponse) {
        return Duration.ofMillis(this.clock.millis() - cachedResponse.timestamp().getTime());
    }

    private static void rewriteCacheControlMaxAge(HttpHeaders headers, long seconds) {
        boolean isMaxAgePresent = headers.getCacheControl() != null && headers.getCacheControl().contains(MAX_AGE_PREFIX);
        ArrayList<Object> newCacheControlDirectives = new ArrayList<Object>();
        if (isMaxAgePresent) {
            List cacheControlHeaders = headers.get("Cache-Control");
            cacheControlHeaders = cacheControlHeaders == null ? Collections.emptyList() : cacheControlHeaders;
            for (String value : cacheControlHeaders) {
                if (value.contains(MAX_AGE_PREFIX)) {
                    if (seconds == -1L) {
                        List removedMaxAgeList = Arrays.stream(value.split(",")).filter(i -> !i.trim().startsWith(MAX_AGE_PREFIX)).collect(Collectors.toList());
                        value = String.join((CharSequence)",", removedMaxAgeList);
                    } else {
                        value = value.replaceFirst("\\bmax-age=\\d+\\b", MAX_AGE_PREFIX + seconds);
                    }
                }
                newCacheControlDirectives.add(value);
            }
        } else {
            List cacheControlHeaders = headers.get("Cache-Control");
            newCacheControlDirectives = cacheControlHeaders == null ? new ArrayList() : new ArrayList(cacheControlHeaders);
            newCacheControlDirectives.add(MAX_AGE_PREFIX + seconds);
        }
        headers.remove("Cache-Control");
        headers.addAll("Cache-Control", newCacheControlDirectives);
    }
}

