/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractNameValueGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class AddResponseHeaderGatewayFilterFactory
extends AbstractNameValueGatewayFilterFactory {
    private static final String OVERRIDE_KEY = "override";

    @Override
    public Class getConfigClass() {
        return Config.class;
    }

    @Override
    public AbstractNameValueGatewayFilterFactory.NameValueConfig newConfig() {
        return new Config();
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("name", "value", OVERRIDE_KEY);
    }

    @Override
    public GatewayFilter apply(final AbstractNameValueGatewayFilterFactory.NameValueConfig config) {
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                return chain.filter(exchange).then(Mono.fromRunnable(() -> AddResponseHeaderGatewayFilterFactory.this.addHeader(exchange, config)));
            }

            public String toString() {
                if (config instanceof Config) {
                    return GatewayToStringStyler.filterToStringCreator(AddResponseHeaderGatewayFilterFactory.this).append("name", (Object)config.getName()).append("value", (Object)config.getValue()).append(AddResponseHeaderGatewayFilterFactory.OVERRIDE_KEY, ((Config)config).isOverride()).toString();
                }
                return GatewayToStringStyler.filterToStringCreator(AddResponseHeaderGatewayFilterFactory.this).append(config.getName(), (Object)config.getValue()).toString();
            }
        };
    }

    void addHeader(ServerWebExchange exchange, AbstractNameValueGatewayFilterFactory.NameValueConfig config) {
        if (!exchange.getResponse().isCommitted()) {
            String value = ServerWebExchangeUtils.expand(exchange, config.getValue());
            HttpHeaders headers = exchange.getResponse().getHeaders();
            boolean override = true;
            if (config instanceof Config) {
                override = ((Config)config).isOverride();
            }
            if (override) {
                headers.add(config.getName(), value);
            } else {
                boolean headerIsMissingOrBlank = headers.getOrEmpty(config.getName()).stream().allMatch(h -> !StringUtils.hasText((String)h));
                if (headerIsMissingOrBlank) {
                    headers.add(config.getName(), value);
                }
            }
        }
    }

    public static class Config
    extends AbstractNameValueGatewayFilterFactory.NameValueConfig {
        private boolean override = true;

        public boolean isOverride() {
            return this.override;
        }

        public Config setOverride(boolean override) {
            this.override = override;
            return this;
        }

        @Override
        public String toString() {
            return new ToStringCreator((Object)this).append("name", (Object)this.name).append("value", (Object)this.value).append(AddResponseHeaderGatewayFilterFactory.OVERRIDE_KEY, this.override).toString();
        }
    }
}

