/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.sample;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.sample.AdditionalRoutes;
import org.springframework.cloud.gateway.sample.GatewaySampleApplication;
import org.springframework.cloud.gateway.sample.ThrottleGatewayFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

@SpringBootConfiguration
@EnableAutoConfiguration
@Import(value={AdditionalRoutes.class})
public class GatewaySampleApplication {
    public static final String HELLO_FROM_FAKE_ACTUATOR_METRICS_GATEWAY_REQUESTS = "hello from fake /actuator/metrics/spring.cloud.gateway.requests";
    @Value(value="${test.uri:http://httpbin.org:80}")
    String uri;

    public static void main(String[] args) {
        SpringApplication.run(GatewaySampleApplication.class, (String[])args);
    }

    @Bean
    public RouteLocator customRouteLocator(RouteLocatorBuilder builder) {
        return builder.routes().route(r -> r.host(new String[]{"**.abc.org"}).and().path(new String[]{"/anything/png"}).filters(f -> f.prefixPath("/httpbin").addResponseHeader("X-TestHeader", "foobar")).uri(this.uri)).route("read_body_pred", r -> r.host(new String[]{"*.readbody.org"}).and().readBody(String.class, s -> s.trim().equalsIgnoreCase("hi")).filters(f -> f.prefixPath("/httpbin").addResponseHeader("X-TestHeader", "read_body_pred")).uri(this.uri)).route("rewrite_request_obj", r -> r.host(new String[]{"*.rewriterequestobj.org"}).filters(f -> f.prefixPath("/httpbin").addResponseHeader("X-TestHeader", "rewrite_request").modifyRequestBody(String.class, Hello.class, "application/json", (exchange, s) -> Mono.just((Object)new Hello(s.toUpperCase(Locale.ROOT))))).uri(this.uri)).route("rewrite_request_upper", r -> r.host(new String[]{"*.rewriterequestupper.org"}).filters(f -> f.prefixPath("/httpbin").addResponseHeader("X-TestHeader", "rewrite_request_upper").modifyRequestBody(String.class, String.class, (exchange, s) -> Mono.just((Object)(s.toUpperCase(Locale.ROOT) + s.toUpperCase(Locale.ROOT))))).uri(this.uri)).route("rewrite_response_upper", r -> r.host(new String[]{"*.rewriteresponseupper.org"}).filters(f -> f.prefixPath("/httpbin").addResponseHeader("X-TestHeader", "rewrite_response_upper").modifyResponseBody(String.class, String.class, (exchange, s) -> Mono.just((Object)s.toUpperCase(Locale.ROOT)))).uri(this.uri)).route("rewrite_empty_response", r -> r.host(new String[]{"*.rewriteemptyresponse.org"}).filters(f -> f.prefixPath("/httpbin").addResponseHeader("X-TestHeader", "rewrite_empty_response").modifyResponseBody(String.class, String.class, (exchange, s) -> {
            if (s == null) {
                return Mono.just((Object)"emptybody");
            }
            return Mono.just((Object)s.toUpperCase(Locale.ROOT));
        })).uri(this.uri)).route("rewrite_response_fail_supplier", r -> r.host(new String[]{"*.rewriteresponsewithfailsupplier.org"}).filters(f -> f.prefixPath("/httpbin").addResponseHeader("X-TestHeader", "rewrite_response_fail_supplier").modifyResponseBody(String.class, String.class, (exchange, s) -> {
            if (s == null) {
                return Mono.error((Throwable)new IllegalArgumentException("this should not happen"));
            }
            return Mono.just((Object)s.toUpperCase(Locale.ROOT));
        })).uri(this.uri)).route("rewrite_response_obj", r -> r.host(new String[]{"*.rewriteresponseobj.org"}).filters(f -> f.prefixPath("/httpbin").addResponseHeader("X-TestHeader", "rewrite_response_obj").modifyResponseBody(Map.class, String.class, "text/plain", (exchange, map) -> {
            Object data = map.get("data");
            return Mono.just((Object)data.toString());
        }).setResponseHeader("Content-Type", "text/plain")).uri(this.uri)).route(r -> r.path(new String[]{"/image/webp"}).filters(f -> f.prefixPath("/httpbin").addResponseHeader("X-AnotherHeader", "baz")).uri(this.uri)).route(r -> r.order(-1).host(new String[]{"**.throttle.org"}).and().path(new String[]{"/get"}).filters(f -> f.prefixPath("/httpbin").filter((GatewayFilter)new ThrottleGatewayFilter().setCapacity(1).setRefillTokens(1).setRefillPeriod(10).setRefillUnit(TimeUnit.SECONDS))).uri(this.uri)).build();
    }

    @Bean
    public RouterFunction<ServerResponse> testFunRouterFunction() {
        RouterFunction route = RouterFunctions.route((RequestPredicate)RequestPredicates.path((String)"/testfun"), request -> ServerResponse.ok().body(BodyInserters.fromValue((Object)"hello")));
        return route;
    }

    @Bean
    public RouterFunction<ServerResponse> testWhenMetricPathIsNotMeet() {
        RouterFunction route = RouterFunctions.route((RequestPredicate)RequestPredicates.path((String)"/actuator/metrics/spring.cloud.gateway.requests"), request -> ServerResponse.ok().body(BodyInserters.fromValue((Object)HELLO_FROM_FAKE_ACTUATOR_METRICS_GATEWAY_REQUESTS)));
        return route;
    }
}

