/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.context.message.MessageUtils;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.cloud.function.web.util.FunctionWebUtils;
import org.springframework.cloud.function.web.util.HeaderUtils;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.messaging.Message;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RequestProcessor {
    private static Log logger = LogFactory.getLog(RequestProcessor.class);
    private final JsonMapper mapper;

    public RequestProcessor(ObjectProvider<JsonMapper> mapper, ObjectProvider<ServerCodecConfigurer> codecs) {
        this.mapper = (JsonMapper)mapper.getIfAvailable();
    }

    public static FunctionWrapper wrapper(SimpleFunctionRegistry.FunctionInvocationWrapper function) {
        return new FunctionWrapper(function);
    }

    public Mono<ResponseEntity<?>> get(FunctionWrapper wrapper) {
        if (wrapper.function().isFunction()) {
            return this.response(wrapper, wrapper.function(), this.invokeFunction(wrapper), true, true);
        }
        SimpleFunctionRegistry.FunctionInvocationWrapper function = wrapper.function;
        Object result = FunctionWebUtils.invokeFunction(function, null, false);
        return this.response(wrapper, wrapper.function(), (Publisher<?>)(result instanceof Publisher ? (Publisher)result : Flux.just((Object)result)), null, true);
    }

    public Mono<ResponseEntity<?>> post(FunctionWrapper wrapper, String body, boolean stream) {
        Object input;
        SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)wrapper.handler();
        Class<Object> itemType = function != null ? function.getItemType(function.getInputType()) : Object.class;
        Object object = input = body == null ? "" : body;
        if (input != null && JsonMapper.isJsonStringRepresentsCollection((Object)input)) {
            Type type = FunctionTypeUtils.isTypeCollection(itemType) ? ResolvableType.forType(itemType).getType() : ResolvableType.forClassWithGenerics(Collection.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType(itemType)}).asCollection().getType();
            input = this.mapper.fromJson(input, type);
        }
        return this.response(wrapper, input, stream);
    }

    public Mono<ResponseEntity<?>> stream(FunctionWrapper functionWrapper) {
        Publisher result = functionWrapper.function.isFunction() ? this.invokeFunction(functionWrapper) : (Publisher)functionWrapper.function.get();
        return this.stream(functionWrapper, result);
    }

    public Mono<ResponseEntity<?>> response(FunctionWrapper wrapper, Object body, boolean stream) {
        Flux flux;
        Class inputType;
        SimpleFunctionRegistry.FunctionInvocationWrapper function = wrapper.function();
        Class clazz = inputType = function == null ? Object.class : FunctionTypeUtils.getRawType((Type)FunctionTypeUtils.getGenericType((Type)function.getInputType()));
        if (MultiValueMap.class.isAssignableFrom(inputType)) {
            body = null;
            flux = Flux.just(wrapper.params());
        } else if (body != null) {
            if (Collection.class.isAssignableFrom(inputType)) {
                flux = Flux.just((Object)body);
            } else if (body instanceof Flux) {
                flux = Flux.from((Publisher)((Flux)body));
            } else {
                List<Object> iterable = body instanceof Collection ? (List<Object>)body : Collections.singletonList(body);
                flux = Flux.fromIterable(iterable);
            }
        } else {
            throw new IllegalStateException("Failed to determine input for function call with parameters: '" + wrapper.params + "' and headers: `" + wrapper.headers + "`");
        }
        if (function != null) {
            flux = this.messages(wrapper, function, flux);
        }
        Mono<ResponseEntity<?>> responseEntityMono = null;
        if (function == null) {
            responseEntityMono = Mono.just((Object)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)"Function for provided path can not be found"));
        } else {
            Publisher result = (Publisher)FunctionWebUtils.invokeFunction(function, flux, function.isInputTypeMessage());
            if (function.isConsumer()) {
                if (result != null) {
                    ((Mono)result).subscribe();
                }
                logger.debug((Object)"Handled POST with consumer");
                responseEntityMono = Mono.just((Object)ResponseEntity.status((HttpStatus)HttpStatus.ACCEPTED).build());
            } else {
                result = Flux.from((Publisher)result);
                logger.debug((Object)("Handled POST with function: " + function));
                responseEntityMono = stream ? this.stream(wrapper, result) : this.response(wrapper, function, result, body == null ? null : Boolean.valueOf(!(body instanceof Collection)), false);
            }
        }
        return responseEntityMono;
    }

    private Mono<ResponseEntity<?>> response(FunctionWrapper request, Object handler, Publisher<?> result, Boolean single, boolean getter) {
        ResponseEntity.BodyBuilder builder = ResponseEntity.ok();
        result = result instanceof Mono ? Mono.from(result).map(message -> MessageUtils.unpack((Object)handler, (Object)message)).doOnNext(value -> {
            this.addHeaders(builder, (Message<?>)value);
            if (!this.isValidCloudEvent(value.getHeaders().keySet())) {
                // empty if block
            }
        }).map(message -> message.getPayload()) : Flux.from(result).map(message -> MessageUtils.unpack((Object)handler, (Object)message)).doOnNext(value -> {
            this.addHeaders(builder, (Message<?>)value);
            if (!this.isValidCloudEvent(value.getHeaders().keySet())) {
                // empty if block
            }
        }).map(message -> message.getPayload());
        if (this.isOutputSingle(handler) && (single != null && single.booleanValue() || getter || this.isInputMultiple(handler))) {
            result = Mono.from((Publisher)result);
        }
        if (result instanceof Flux) {
            result = Flux.from((Publisher)result).onErrorContinue((e, v) -> logger.error((Object)("Failed to process value: " + v), e)).collectList();
        }
        return Mono.from((Publisher)result).flatMap(body -> Mono.just((Object)builder.body(body)));
    }

    private boolean isValidCloudEvent(Set<String> headerKeys) {
        return headerKeys.contains("ce-id") && headerKeys.contains("ce-source") && headerKeys.contains("ce-type") && headerKeys.contains("ce-specversion");
    }

    private Flux<?> messages(FunctionWrapper request, Object function, Flux<?> flux) {
        HashMap<String, String> headers = new HashMap<String, String>((Map<String, String>)HeaderUtils.fromHttp(request.headers()));
        if (function instanceof SimpleFunctionRegistry.FunctionInvocationWrapper) {
            headers.put("scf-func-name", ((SimpleFunctionRegistry.FunctionInvocationWrapper)function).getFunctionDefinition());
        }
        return flux.map(payload -> MessageUtils.create((Object)function, (Object)payload, (Map)headers));
    }

    private void addHeaders(ResponseEntity.BodyBuilder builder, Message<?> message) {
        builder.headers(HeaderUtils.fromMessage(message.getHeaders()));
    }

    private Mono<ResponseEntity<?>> stream(FunctionWrapper request, Publisher<?> result) {
        ResponseEntity.BodyBuilder builder = ResponseEntity.ok();
        if (((SimpleFunctionRegistry.FunctionInvocationWrapper)request.handler()).isInputTypeMessage()) {
            result = Flux.from(result).doOnNext(value -> this.addHeaders(builder, (Message)value)).map(message -> MessageUtils.unpack((Object)request.handler(), (Object)message).getPayload());
        } else {
            builder.headers(HeaderUtils.sanitize(request.headers()));
        }
        Flux output = result;
        return Flux.from((Publisher)output).then(Mono.fromSupplier(() -> RequestProcessor.lambda$stream$11(builder, (Publisher)output)));
    }

    private boolean isInputMultiple(Object handler) {
        SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)handler;
        Class type = function == null ? Object.class : FunctionTypeUtils.getRawType((Type)FunctionTypeUtils.getGenericType((Type)function.getInputType()));
        return Collection.class.isAssignableFrom(type) || function != null && FunctionTypeUtils.isFlux((Type)function.getInputType());
    }

    private boolean isOutputSingle(Object handler) {
        Class wrapper;
        SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)handler;
        Type outputType = function.getOutputType();
        Class type = FunctionTypeUtils.getRawType((Type)FunctionTypeUtils.getGenericType((Type)outputType));
        Class clazz = wrapper = function.isOutputTypePublisher() ? FunctionTypeUtils.getRawType((Type)outputType) : type;
        if (Stream.class.isAssignableFrom(type)) {
            return false;
        }
        return wrapper == type || Mono.class.equals((Object)wrapper) || Optional.class.equals((Object)wrapper);
    }

    private Publisher<?> invokeFunction(FunctionWrapper wrapper) {
        if (wrapper.argument != null) {
            Flux input = Flux.from((Publisher)wrapper.argument);
            Object result = FunctionWebUtils.invokeFunction(wrapper.function, input, wrapper.function.isInputTypeMessage());
            return Mono.from((Publisher)((Publisher)result));
        }
        return Mono.empty();
    }

    private static /* synthetic */ ResponseEntity lambda$stream$11(ResponseEntity.BodyBuilder builder, Publisher output) {
        return builder.body((Object)output);
    }

    public static class FunctionWrapper {
        private final SimpleFunctionRegistry.FunctionInvocationWrapper function;
        private final MultiValueMap<String, String> params = new LinkedMultiValueMap();
        private HttpHeaders headers = new HttpHeaders();
        private Publisher<String> argument;

        public FunctionWrapper(SimpleFunctionRegistry.FunctionInvocationWrapper function) {
            this.function = function;
        }

        public Object handler() {
            return this.function;
        }

        public SimpleFunctionRegistry.FunctionInvocationWrapper function() {
            return this.function;
        }

        @Deprecated
        public Supplier<?> supplier() {
            return this.function;
        }

        public MultiValueMap<String, String> params() {
            return this.params;
        }

        public HttpHeaders headers() {
            return this.headers;
        }

        public FunctionWrapper headers(HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        public FunctionWrapper params(MultiValueMap<String, String> params) {
            this.params.addAll(params);
            return this;
        }

        public FunctionWrapper argument(Publisher<String> argument) {
            this.argument = argument;
            return this;
        }

        public FunctionWrapper argument(String argument) {
            this.argument = Mono.just((Object)argument);
            return this;
        }

        public Publisher<String> argument() {
            return this.argument;
        }
    }
}

