/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.stream.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.stream.config.StreamConfigurationProperties;
import org.springframework.cloud.function.stream.config.StreamListeningConsumerInvoker;
import org.springframework.cloud.function.stream.config.StreamListeningFunctionInvoker;
import org.springframework.cloud.function.stream.config.SupplierInvokingMessageProducer;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.cloud.stream.messaging.Processor;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@EnableConfigurationProperties(value={StreamConfigurationProperties.class})
@ConditionalOnClass(value={Binder.class})
@ConditionalOnBean(value={FunctionCatalog.class})
@ConditionalOnProperty(name={"spring.cloud.stream.enabled"}, havingValue="true", matchIfMissing=true)
public class StreamAutoConfiguration {

    private static class SinkCondition
    extends SpringBootCondition {
        private SinkCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Boolean enabled = (Boolean)context.getEnvironment().getProperty("spring.cloud.function.stream.sink.enabled", Boolean.class);
            Boolean source = (Boolean)context.getEnvironment().getProperty("spring.cloud.function.stream.source.enabled", Boolean.class, (Object)true);
            if (enabled != null && enabled.booleanValue()) {
                if (!source.booleanValue()) {
                    return ConditionOutcome.match((String)"Sink explicitly enabled and source disabled");
                }
                return ConditionOutcome.noMatch((String)"Sink explicitly enabled and source enabled");
            }
            if (enabled == null) {
                if (!source.booleanValue()) {
                    return ConditionOutcome.match((String)"Sink implicitly enabled and source disabled");
                }
                return ConditionOutcome.noMatch((String)"Sink not explicitly enabled and source enabled");
            }
            return ConditionOutcome.noMatch((String)"Sink explicitly disabled");
        }
    }

    private static class SourceCondition
    extends SpringBootCondition {
        private SourceCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Boolean enabled = (Boolean)context.getEnvironment().getProperty("spring.cloud.function.stream.source.enabled", Boolean.class);
            Boolean sink = (Boolean)context.getEnvironment().getProperty("spring.cloud.function.stream.sink.enabled", Boolean.class, (Object)true);
            if (enabled != null && enabled.booleanValue()) {
                if (!sink.booleanValue()) {
                    return ConditionOutcome.match((String)"Source explicitly enabled and sink disabled");
                }
                return ConditionOutcome.noMatch((String)"Source explicitly enabled and sink enabled");
            }
            if (enabled == null) {
                if (!sink.booleanValue()) {
                    return ConditionOutcome.match((String)"Source implicitly enabled and sink disabled");
                }
                return ConditionOutcome.noMatch((String)"Source not explicitly enabled and sink enabled");
            }
            return ConditionOutcome.noMatch((String)"Source explicitly disabled");
        }
    }

    private static class ProcessorCondition
    extends SpringBootCondition {
        private SourceCondition source = new SourceCondition();
        private SinkCondition sink = new SinkCondition();

        private ProcessorCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return !this.source.matches(context, metadata) && !this.sink.matches(context, metadata) ? ConditionOutcome.match((String)"Neither source nor sink is explicitly disabled") : ConditionOutcome.noMatch((String)"Either sink or source was explicitly disabled");
        }
    }

    private static class SourceAndSinkCondition
    extends SpringBootCondition {
        private SourceCondition source = new SourceCondition();
        private SinkCondition sink = new SinkCondition();
        private ProcessorCondition processor = new ProcessorCondition();

        private SourceAndSinkCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            if (this.processor.matches(context, metadata)) {
                return ConditionOutcome.match((String)"Processor is bound");
            }
            if (this.sink.matches(context, metadata) && this.source.matches(context, metadata)) {
                return ConditionOutcome.match((String)"Both Source and Sink are bound");
            }
            return ConditionOutcome.noMatch((String)"Both Source and Sink are not bound");
        }
    }

    private static class SinkOnlyCondition
    extends SpringBootCondition {
        private SourceAndSinkCondition processor = new SourceAndSinkCondition();
        private SinkCondition sink = new SinkCondition();

        private SinkOnlyCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            if (this.processor.matches(context, metadata)) {
                return ConditionOutcome.noMatch((String)"Source is provided by Processor");
            }
            if (this.sink.matches(context, metadata)) {
                return ConditionOutcome.match((String)"Sink is explicitly enabled");
            }
            return ConditionOutcome.noMatch((String)"Sink is not enabled and not available through Processor");
        }
    }

    @Configuration
    @EnableBinding(value={Sink.class})
    @Conditional(value={SinkCondition.class})
    protected class SinkBindingConfiguration {
        protected SinkBindingConfiguration() {
        }
    }

    @Configuration
    @EnableBinding(value={Source.class})
    @Conditional(value={SourceCondition.class})
    protected class SourceBindingConfiguration {
        protected SourceBindingConfiguration() {
        }
    }

    @Configuration
    @EnableBinding(value={Processor.class})
    @Conditional(value={ProcessorCondition.class})
    protected class ProcessorBindingConfiguration {
        protected ProcessorBindingConfiguration() {
        }
    }

    @Configuration
    @Conditional(value={SinkOnlyCondition.class})
    protected static class SinkConfiguration {
        @Autowired
        private StreamConfigurationProperties properties;

        @Bean
        public StreamListeningConsumerInvoker consumerInvoker(FunctionCatalog registry, FunctionInspector functionInspector, @Lazy CompositeMessageConverterFactory compositeMessageConverterFactory) {
            return new StreamListeningConsumerInvoker(registry, functionInspector, compositeMessageConverterFactory, this.properties.getSink().getName(), this.properties.isShared());
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"spring.cloud.function.stream.processor.enabled"}, havingValue="true", matchIfMissing=true)
    @Conditional(value={SourceAndSinkCondition.class})
    protected static class ProcessorConfiguration {
        @Autowired
        private StreamConfigurationProperties properties;

        protected ProcessorConfiguration() {
        }

        @Bean
        public StreamListeningFunctionInvoker functionInvoker(FunctionCatalog registry, FunctionInspector functionInspector, @Lazy CompositeMessageConverterFactory compositeMessageConverterFactory) {
            return new StreamListeningFunctionInvoker(registry, functionInspector, compositeMessageConverterFactory, this.properties.getDefaultRoute(), this.properties.isShared());
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"spring.cloud.function.stream.source.enabled"}, havingValue="true", matchIfMissing=true)
    protected static class SourceConfiguration {
        @Autowired
        private StreamConfigurationProperties properties;

        protected SourceConfiguration() {
        }

        @Bean
        public SupplierInvokingMessageProducer<Object> supplierInvoker(FunctionCatalog registry) {
            return new SupplierInvokingMessageProducer<Object>(registry, this.properties.getSource().getName());
        }
    }
}

