/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.rsocket;

import io.rsocket.broker.client.spring.BrokerClientAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.function.rsocket.FunctionRSocketMessageHandler;
import org.springframework.cloud.function.rsocket.RSocketAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.rsocket.RSocketConnectorConfigurer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={BrokerClientAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.cloud.function.rsocket.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={BrokerClientAutoConfiguration.class})
@AutoConfigureAfter(value={RSocketAutoConfiguration.class})
class RSocketRoutingAutoConfiguration {
    RSocketRoutingAutoConfiguration() {
    }

    @Bean
    RSocketConnectorConfigurer functionRSocketConnectorConfigurer(FunctionRSocketMessageHandler handler) {
        return connector -> connector.acceptor(handler.responder());
    }
}

