/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.grpc;

import java.util.function.Function;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.function.context.MessageRoutingCallback;
import org.springframework.cloud.function.grpc.FunctionGrpcProperties;
import org.springframework.cloud.function.grpc.GrpcUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.Message;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={FunctionGrpcProperties.class})
public class GrpcFunctionAutoConfiguration {
    public static String GRPC_INVOKER_FUNCTION = "grpcInvokerFunction";
    public static String GRPC = "grpc";
    public static String GRPC_HOST = "grpcHost";
    public static String GRPC_PORT = "grpcPort";

    @Bean
    public Function<Message<byte[]>, Message<?>> grpcInvokerFunction() {
        return message -> {
            if (message.getHeaders().containsKey((Object)GRPC_HOST)) {
                int n;
                String host = (String)message.getHeaders().get((Object)GRPC_HOST);
                Object object = message.getHeaders().get((Object)GRPC_PORT);
                if (object instanceof String) {
                    String stringPort = (String)object;
                    n = Integer.parseInt(stringPort);
                } else {
                    n = (Integer)message.getHeaders().get((Object)GRPC_PORT);
                }
                int port = n;
                return GrpcUtils.requestReply(host, port, (Message<byte[]>)message);
            }
            return GrpcUtils.requestReply((Message<byte[]>)message);
        };
    }

    @Bean
    public MessageRoutingCallback routingCallback() {
        return new MessageRoutingCallback(){

            public String routingResult(Message<?> message) {
                if (message.getHeaders().containsKey((Object)"proxy") && message.getHeaders().get((Object)"proxy").equals(GRPC)) {
                    return GRPC_INVOKER_FUNCTION;
                }
                return null;
            }
        };
    }
}

