/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.deployer.utils;

import org.springframework.cloud.function.deployer.utils.MavenProperties;
import org.springframework.cloud.function.deployer.utils.MavenResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MavenResourceLoader
implements ResourceLoader {
    private static final String URI_SCHEME = "maven";
    private final MavenProperties properties;
    private final ClassLoader classLoader = ClassUtils.getDefaultClassLoader();

    public MavenResourceLoader(MavenProperties properties) {
        Assert.notNull((Object)properties, (String)"MavenProperties must not be null");
        this.properties = properties;
    }

    public Resource getResource(String location) {
        Assert.hasText((String)location, (String)"location is required");
        String coordinates = location.replaceFirst("maven:\\/*", "");
        return MavenResource.parse(coordinates, this.properties);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

