/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.deployer;

import java.util.ArrayList;
import javax.annotation.PostConstruct;
import org.springframework.util.StringUtils;

public class FunctionProperties {
    private String[] location = new String[0];
    private String[] bean = new String[0];
    private String main;

    public static String functionName(String name) {
        if (!name.contains(",")) {
            return "function0";
        }
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i <= StringUtils.countOccurrencesOf((String)name, (String)","); ++i) {
            names.add("function" + i);
        }
        return StringUtils.collectionToDelimitedString(names, (String)"|");
    }

    public static String functionName(int value) {
        return "function" + value;
    }

    public String getName() {
        return FunctionProperties.functionName(StringUtils.arrayToDelimitedString((Object[])this.bean, (String)","));
    }

    public String[] getBean() {
        return this.bean;
    }

    public void setBean(String[] bean) {
        this.bean = bean;
    }

    public String[] getLocation() {
        return this.location;
    }

    public void setLocation(String[] location) {
        this.location = location;
    }

    public String getMain() {
        return this.main;
    }

    public void setMain(String main) {
        this.main = main;
    }

    @PostConstruct
    public void init() {
        if (this.location.length == 0) {
            throw new IllegalStateException("No archive location provided, please configure function.location as a jar or directory.");
        }
    }
}

