/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.wrapper;

import java.lang.reflect.Type;
import java.util.function.Supplier;
import kotlin.jvm.functions.Function0;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionWrapper;
import org.springframework.cloud.function.utils.KotlinUtils;
import org.springframework.core.ResolvableType;
import org.springframework.util.ObjectUtils;

public final class KotlinSupplierPlainWrapper
implements KotlinFunctionWrapper,
Supplier<Object>,
Function0<Object> {
    private final Object kotlinLambdaTarget;
    private final String name;
    private final ResolvableType type;

    public static Boolean isValid(Type functionType, Type[] types) {
        return KotlinUtils.isValidKotlinSupplier(functionType);
    }

    public static KotlinSupplierPlainWrapper asRegistrationFunction(String functionName, Object kotlinLambdaTarget, Type[] propsTypes) {
        ResolvableType functionType = ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)propsTypes[0])});
        return new KotlinSupplierPlainWrapper(kotlinLambdaTarget, functionType, functionName);
    }

    public KotlinSupplierPlainWrapper(Object kotlinLambdaTarget, ResolvableType type, String functionName) {
        this.name = functionName;
        this.kotlinLambdaTarget = kotlinLambdaTarget;
        this.type = type;
    }

    public Object apply(Object input) {
        if (ObjectUtils.isEmpty((Object)input)) {
            return this.get();
        }
        return null;
    }

    @Override
    public Object get() {
        return this.invoke();
    }

    public Object invoke() {
        if (this.kotlinLambdaTarget instanceof Function0) {
            return ((Function0)this.kotlinLambdaTarget).invoke();
        }
        if (this.kotlinLambdaTarget instanceof Supplier) {
            return ((Supplier)this.kotlinLambdaTarget).get();
        }
        throw new IllegalArgumentException("Unsupported target type: " + this.kotlinLambdaTarget.getClass());
    }

    @Override
    public ResolvableType getResolvableType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

