/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.wrapper;

import java.lang.reflect.Type;
import java.util.function.Function;
import kotlin.jvm.functions.Function1;
import org.springframework.cloud.function.context.config.CoroutinesUtils;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionWrapper;
import org.springframework.cloud.function.utils.KotlinUtils;
import org.springframework.core.ResolvableType;
import reactor.core.publisher.Flux;

public final class KotlinFunctionSuspendPlainToPlainWrapper
implements KotlinFunctionWrapper,
Function<Object, Object>,
Function1<Object, Object> {
    private final Object kotlinLambdaTarget;
    private String name;
    private final ResolvableType type;

    public static Boolean isValid(Type functionType, Type[] types) {
        return KotlinUtils.isValidKotlinSuspendFunction(functionType, types);
    }

    public static KotlinFunctionSuspendPlainToPlainWrapper asRegistrationFunction(String functionName, Object kotlinLambdaTarget, Type[] propsTypes) {
        ResolvableType argType = KotlinUtils.getSuspendingFunctionArgType(propsTypes[0]);
        ResolvableType returnType = KotlinUtils.getSuspendingFunctionReturnType(propsTypes[1]);
        ResolvableType functionType = ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{argType, ResolvableType.forClassWithGenerics(Flux.class, (ResolvableType[])new ResolvableType[]{returnType})});
        return new KotlinFunctionSuspendPlainToPlainWrapper(kotlinLambdaTarget, functionType, functionName);
    }

    public KotlinFunctionSuspendPlainToPlainWrapper(Object kotlinLambdaTarget, ResolvableType type, String functionName) {
        this.name = functionName;
        this.kotlinLambdaTarget = kotlinLambdaTarget;
        this.type = type;
    }

    @Override
    public ResolvableType getResolvableType() {
        return this.type;
    }

    public Object invoke(Object arg0) {
        return CoroutinesUtils.invokeSuspendingSingleFunction(this.kotlinLambdaTarget, arg0);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object apply(Object input) {
        return this.invoke(input);
    }
}

