/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.wrapper;

import java.lang.reflect.Type;
import java.util.function.Function;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionWrapper;
import org.springframework.cloud.function.utils.KotlinUtils;
import org.springframework.core.ResolvableType;
import reactor.core.publisher.Flux;

public final class KotlinFunctionPlainToFlowWrapper
implements KotlinFunctionWrapper,
Function<Object, Flux<Object>>,
Function1<Object, Flux<Object>> {
    private final Object kotlinLambdaTarget;
    private final String name;
    private final ResolvableType type;

    public static Boolean isValid(Type functionType, Type[] types) {
        return KotlinUtils.isValidKotlinFunction(functionType, types) && types.length == 2 && !KotlinUtils.isFlowType(types[0]) && KotlinUtils.isFlowType(types[1]);
    }

    public static KotlinFunctionPlainToFlowWrapper asRegistrationFunction(String functionName, Object kotlinLambdaTarget, Type[] propsTypes) {
        ResolvableType props = ResolvableType.forType((Type)propsTypes[0]);
        ResolvableType result = ResolvableType.forClassWithGenerics(Flux.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)propsTypes[1])});
        ResolvableType functionType = ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{props, result});
        return new KotlinFunctionPlainToFlowWrapper(kotlinLambdaTarget, functionType, functionName);
    }

    public KotlinFunctionPlainToFlowWrapper(Object kotlinLambdaTarget, ResolvableType type, String functionName) {
        this.kotlinLambdaTarget = kotlinLambdaTarget;
        this.name = functionName;
        this.type = type;
    }

    public Flux<Object> invoke(Object arg0) {
        if (this.kotlinLambdaTarget instanceof Function) {
            Function target = (Function)this.kotlinLambdaTarget;
            Flow result = (Flow)target.apply(arg0);
            return KotlinUtils.convertToFlux(result);
        }
        if (this.kotlinLambdaTarget instanceof Function1) {
            Function1 target = (Function1)this.kotlinLambdaTarget;
            Flow result = (Flow)target.invoke(arg0);
            return KotlinUtils.convertToFlux(result);
        }
        throw new IllegalArgumentException("Unsupported target type: " + this.kotlinLambdaTarget.getClass());
    }

    @Override
    public ResolvableType getResolvableType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Flux<Object> apply(Object input) {
        return this.invoke(input);
    }
}

