/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.wrapper;

import java.lang.reflect.Type;
import java.util.function.Consumer;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.springframework.cloud.function.context.config.CoroutinesUtils;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionWrapper;
import org.springframework.cloud.function.utils.KotlinUtils;
import org.springframework.core.ResolvableType;
import reactor.core.publisher.Flux;

public final class KotlinConsumerSuspendFlowWrapper
implements KotlinFunctionWrapper,
Consumer<Flux<Object>>,
Function1<Flux<Object>, Unit> {
    private final Object kotlinLambdaTarget;
    private String name;
    private final ResolvableType type;

    public static Boolean isValid(Type functionType, Type[] types) {
        return KotlinUtils.isValidKotlinSuspendConsumer(functionType, types) && KotlinUtils.isFlowType(types[0]);
    }

    public static KotlinConsumerSuspendFlowWrapper asRegistrationFunction(String functionName, Object kotlinLambdaTarget, Type[] propsTypes) {
        ResolvableType continuationArgType = KotlinUtils.getSuspendingFunctionArgType(propsTypes[0]);
        ResolvableType functionType = ResolvableType.forClassWithGenerics(Consumer.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forClassWithGenerics(Flux.class, (ResolvableType[])new ResolvableType[]{continuationArgType})});
        return new KotlinConsumerSuspendFlowWrapper(kotlinLambdaTarget, functionType, functionName);
    }

    public KotlinConsumerSuspendFlowWrapper(Object kotlinLambdaTarget, ResolvableType type, String functionName) {
        this.name = functionName;
        this.kotlinLambdaTarget = kotlinLambdaTarget;
        this.type = type;
    }

    @Override
    public ResolvableType getResolvableType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void accept(Flux<Object> input) {
        this.invoke(input);
    }

    public Unit invoke(Flux<Object> input) {
        CoroutinesUtils.invokeSuspendingConsumerFlow(this.kotlinLambdaTarget, input);
        return Unit.INSTANCE;
    }
}

