/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.config.FunctionContextUtils;
import org.springframework.cloud.function.context.wrapper.KotlinConsumerFlowWrapper;
import org.springframework.cloud.function.context.wrapper.KotlinConsumerPlainWrapper;
import org.springframework.cloud.function.context.wrapper.KotlinConsumerSuspendFlowWrapper;
import org.springframework.cloud.function.context.wrapper.KotlinConsumerSuspendPlainWrapper;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionFlowToFlowWrapper;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionFlowToPlainWrapper;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionPlainToFlowWrapper;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionPlainToPlainWrapper;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionSuspendFlowToFlowWrapper;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionSuspendFlowToPlainWrapper;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionSuspendPlainToFlowWrapper;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionSuspendPlainToPlainWrapper;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionWrapper;
import org.springframework.cloud.function.context.wrapper.KotlinSupplierFlowWrapper;
import org.springframework.cloud.function.context.wrapper.KotlinSupplierPlainWrapper;
import org.springframework.cloud.function.context.wrapper.KotlinSupplierSuspendWrapper;

public final class KotlinLambdaToFunctionFactory {
    private final Object kotlinLambdaTarget;
    private final ConfigurableListableBeanFactory beanFactory;

    public KotlinLambdaToFunctionFactory(Object kotlinLambdaTarget, ConfigurableListableBeanFactory beanFactory) {
        this.kotlinLambdaTarget = kotlinLambdaTarget;
        this.beanFactory = beanFactory;
    }

    public FunctionRegistration<KotlinFunctionWrapper> getFunctionRegistration(String functionName) {
        String name = functionName.endsWith(FunctionRegistration.REGISTRATION_NAME_SUFFIX) ? functionName.replace(FunctionRegistration.REGISTRATION_NAME_SUFFIX, "") : functionName;
        Type functionType = FunctionContextUtils.findType(name, this.beanFactory);
        Type[] types = ((ParameterizedType)functionType).getActualTypeArguments();
        KotlinFunctionWrapper wrapper = null;
        if (KotlinConsumerFlowWrapper.isValid(functionType, types).booleanValue()) {
            wrapper = KotlinConsumerFlowWrapper.asRegistrationFunction(functionName, this.kotlinLambdaTarget, types);
        } else if (KotlinConsumerPlainWrapper.isValid(functionType, types).booleanValue()) {
            wrapper = KotlinConsumerPlainWrapper.asRegistrationFunction(functionName, this.kotlinLambdaTarget, types);
        } else if (KotlinConsumerSuspendFlowWrapper.isValid(functionType, types).booleanValue()) {
            wrapper = KotlinConsumerSuspendFlowWrapper.asRegistrationFunction(functionName, this.kotlinLambdaTarget, types);
        } else if (KotlinConsumerSuspendPlainWrapper.isValid(functionType, types).booleanValue()) {
            wrapper = KotlinConsumerSuspendPlainWrapper.asRegistrationFunction(functionName, this.kotlinLambdaTarget, types);
        } else if (KotlinFunctionFlowToFlowWrapper.isValid(functionType, types).booleanValue()) {
            wrapper = KotlinFunctionFlowToFlowWrapper.asRegistrationFunction(functionName, this.kotlinLambdaTarget, types);
        } else if (KotlinFunctionSuspendFlowToFlowWrapper.isValid(functionType, types).booleanValue()) {
            wrapper = KotlinFunctionSuspendFlowToFlowWrapper.asRegistrationFunction(functionName, this.kotlinLambdaTarget, types);
        } else if (KotlinFunctionFlowToPlainWrapper.isValid(functionType, types).booleanValue()) {
            wrapper = KotlinFunctionFlowToPlainWrapper.asRegistrationFunction(functionName, this.kotlinLambdaTarget, types);
        } else if (KotlinFunctionSuspendFlowToPlainWrapper.isValid(functionType, types).booleanValue()) {
            wrapper = KotlinFunctionSuspendFlowToPlainWrapper.asRegistrationFunction(functionName, this.kotlinLambdaTarget, types);
        } else if (KotlinFunctionPlainToFlowWrapper.isValid(functionType, types).booleanValue()) {
            wrapper = KotlinFunctionPlainToFlowWrapper.asRegistrationFunction(functionName, this.kotlinLambdaTarget, types);
        } else if (KotlinFunctionSuspendPlainToFlowWrapper.isValid(functionType, types).booleanValue()) {
            wrapper = KotlinFunctionSuspendPlainToFlowWrapper.asRegistrationFunction(functionName, this.kotlinLambdaTarget, types);
        } else if (KotlinSupplierFlowWrapper.isValid(functionType, types).booleanValue()) {
            wrapper = KotlinSupplierFlowWrapper.asRegistrationFunction(functionName, this.kotlinLambdaTarget, types);
        } else if (KotlinSupplierPlainWrapper.isValid(functionType, types).booleanValue()) {
            wrapper = KotlinSupplierPlainWrapper.asRegistrationFunction(functionName, this.kotlinLambdaTarget, types);
        } else if (KotlinSupplierSuspendWrapper.isValid(functionType, types).booleanValue()) {
            wrapper = KotlinSupplierSuspendWrapper.asRegistrationFunction(functionName, this.kotlinLambdaTarget, types);
        } else if (KotlinFunctionPlainToPlainWrapper.isValid(functionType, types).booleanValue()) {
            wrapper = KotlinFunctionPlainToPlainWrapper.asRegistrationFunction(functionName, this.kotlinLambdaTarget, types);
        } else if (KotlinFunctionSuspendPlainToPlainWrapper.isValid(functionType, types).booleanValue()) {
            wrapper = KotlinFunctionSuspendPlainToPlainWrapper.asRegistrationFunction(functionName, this.kotlinLambdaTarget, types);
        }
        if (wrapper == null) {
            throw new IllegalStateException("Unable to create function wrapper for " + functionName);
        }
        FunctionRegistration<KotlinFunctionWrapper> registration = new FunctionRegistration<KotlinFunctionWrapper>(wrapper, wrapper.getName());
        registration.type(wrapper.getResolvableType().getType());
        return registration;
    }
}

