/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

public class SmartCompositeMessageConverter
extends CompositeMessageConverter {
    public SmartCompositeMessageConverter(Collection<MessageConverter> converters) {
        super(converters);
    }

    @Nullable
    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        for (MessageConverter converter : this.getConverters()) {
            Object result = converter.fromMessage(message, targetClass);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public Object fromMessage(Message<?> message, Class<?> targetClass, @Nullable Object conversionHint) {
        for (MessageConverter converter : this.getConverters()) {
            Object result = converter instanceof SmartMessageConverter ? ((SmartMessageConverter)converter).fromMessage(message, targetClass, conversionHint) : converter.fromMessage(message, targetClass);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public Message<?> toMessage(Object payload, @Nullable MessageHeaders headers) {
        for (MessageConverter converter : this.getConverters()) {
            String[] contentTypes;
            if (headers.get((Object)"contentType") == null) {
                return null;
            }
            String value = headers.get((Object)"contentType").toString();
            for (String contentType : contentTypes = StringUtils.delimitedListToStringArray((String)value, (String)",")) {
                if (!MimeType.valueOf((String)contentType).isConcrete()) {
                    List supportedMimeTypes = ((AbstractMessageConverter)converter).getSupportedMimeTypes();
                    for (MimeType supportedMimeType : supportedMimeTypes) {
                        if (!supportedMimeType.isCompatibleWith(MimeType.valueOf((String)contentType))) continue;
                        MessageHeaderAccessor h = new MessageHeaderAccessor();
                        h.copyHeaders((Map)headers);
                        h.setHeader("contentType", (Object)supportedMimeType);
                        Message result = converter.toMessage(payload, h.getMessageHeaders());
                        if (result == null) continue;
                        return result;
                    }
                    continue;
                }
                MessageHeaderAccessor h = new MessageHeaderAccessor();
                h.copyHeaders((Map)headers);
                h.setHeader("contentType", (Object)contentType);
                Message result = converter.toMessage(payload, h.getMessageHeaders());
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Nullable
    public Message<?> toMessage(Object payload, @Nullable MessageHeaders headers, @Nullable Object conversionHint) {
        for (MessageConverter converter : this.getConverters()) {
            String[] contentTypes;
            String value = headers.get((Object)"contentType").toString();
            for (String contentType : contentTypes = StringUtils.delimitedListToStringArray((String)value, (String)",")) {
                if (!MimeType.valueOf((String)contentType).isConcrete()) {
                    List supportedMimeTypes = ((AbstractMessageConverter)converter).getSupportedMimeTypes();
                    for (MimeType supportedMimeType : supportedMimeTypes) {
                        MessageHeaderAccessor h = new MessageHeaderAccessor();
                        h.copyHeaders((Map)headers);
                        h.setHeader("contentType", (Object)supportedMimeType);
                        Message result = ((SmartMessageConverter)converter).toMessage(payload, h.getMessageHeaders(), conversionHint);
                        if (result == null) continue;
                        return result;
                    }
                    continue;
                }
                MessageHeaderAccessor h = new MessageHeaderAccessor();
                h.copyHeaders((Map)headers);
                h.setHeader("contentType", (Object)contentType);
                Message result = ((SmartMessageConverter)converter).toMessage(payload, h.getMessageHeaders(), conversionHint);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }
}

