/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.jodah.typetools.TypeResolver;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.config.KotlinLambdaToFunctionAutoConfiguration;
import org.springframework.core.KotlinDetector;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class FunctionRegistration<T>
implements BeanNameAware {
    public static String REGISTRATION_NAME_SUFFIX = "_registration";
    private final Set<String> names = new LinkedHashSet<String>();
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private T target;
    private FunctionType type;

    public FunctionRegistration(T target, String ... names) {
        Assert.notNull(target, (String)"'target' must not be null");
        this.target = target;
        this.names(names);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public void setNames(Set<String> names) {
        this.names.clear();
        this.names.addAll(names);
    }

    public FunctionType getType() {
        return this.type;
    }

    public T getTarget() {
        return this.target;
    }

    public FunctionRegistration<T> properties(Map<String, String> properties) {
        this.properties.putAll(properties);
        return this;
    }

    public FunctionRegistration<T> type(Type type) {
        return this.type(FunctionType.of(type));
    }

    public FunctionRegistration<T> type(FunctionType type) {
        this.type = type;
        if (KotlinDetector.isKotlinPresent() && this.target instanceof KotlinLambdaToFunctionAutoConfiguration.KotlinFunctionWrapper) {
            return this;
        }
        Type t = FunctionTypeUtils.discoverFunctionTypeFromClass(this.target.getClass());
        if (t == null) {
            return null;
        }
        FunctionType discoveredFunctionType = FunctionType.of(t);
        Class inputType = TypeResolver.resolveRawClass(discoveredFunctionType.getInputType(), null);
        Class outputType = TypeResolver.resolveRawClass(discoveredFunctionType.getOutputType(), null);
        if (!inputType.isAssignableFrom(TypeResolver.resolveRawClass(type.getInputType(), null)) || !outputType.isAssignableFrom(TypeResolver.resolveRawClass(type.getOutputType(), null))) {
            throw new IllegalStateException("Discovered function type does not match provided function type. Discovered: " + discoveredFunctionType + "; Provided: " + type);
        }
        return this;
    }

    public FunctionRegistration<T> target(T target) {
        this.target = target;
        return this;
    }

    public FunctionRegistration<T> name(String name) {
        return this.names(name);
    }

    public FunctionRegistration<T> names(Collection<String> names) {
        this.names.addAll(names);
        return this;
    }

    public FunctionRegistration<T> names(String ... names) {
        return this.names(Arrays.asList(names));
    }

    public void setBeanName(String name) {
        if (CollectionUtils.isEmpty(this.names)) {
            this.name(name);
        }
    }
}

