/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.function.adapter.aws.AWSLambdaUtils;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnProperty(value={"AWS_LAMBDA_RUNTIME_API"})
public class CustomRuntimeEventLoop {
    private static Log logger = LogFactory.getLog(CustomRuntimeEventLoop.class);
    private static final String LAMBDA_VERSION_DATE = "2018-06-01";
    private static final String LAMBDA_RUNTIME_URL_TEMPLATE = "http://{0}/{1}/runtime/invocation/next";
    private static final String LAMBDA_INVOCATION_URL_TEMPLATE = "http://{0}/{1}/runtime/invocation/{2}/response";

    @Bean
    @ConditionalOnProperty(value={"AWS_LAMBDA_RUNTIME_API"})
    public CommandLineRunner backgrounder(ApplicationContext applicationContext) {
        return args -> CustomRuntimeEventLoop.eventLoop(applicationContext);
    }

    static void eventLoop(ApplicationContext context) {
        logger.info((Object)"Starting spring-cloud-function CustomRuntimeEventLoop");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AWS LAMBDA ENVIRONMENT: " + System.getenv()));
        }
        String runtimeApi = System.getenv("AWS_LAMBDA_RUNTIME_API");
        String eventUri = MessageFormat.format(LAMBDA_RUNTIME_URL_TEMPLATE, runtimeApi, LAMBDA_VERSION_DATE);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Event URI: " + eventUri));
        }
        RequestEntity requestEntity = RequestEntity.get((URI)URI.create(eventUri)).build();
        FunctionCatalog functionCatalog = (FunctionCatalog)context.getBean(FunctionCatalog.class);
        RestTemplate rest = new RestTemplate();
        ObjectMapper mapper = (ObjectMapper)context.getBean(ObjectMapper.class);
        logger.info((Object)"Entering event loop");
        while (true) {
            logger.debug((Object)"Attempting to get new event");
            ResponseEntity response = rest.exchange(requestEntity, String.class);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("New Event received: " + (String)response.getBody()));
            }
            SimpleFunctionRegistry.FunctionInvocationWrapper function = CustomRuntimeEventLoop.locateFunction(functionCatalog, response.getHeaders().getContentType());
            Message<byte[]> eventMessage = AWSLambdaUtils.generateMessage(((String)response.getBody()).getBytes(StandardCharsets.UTF_8), CustomRuntimeEventLoop.fromHttp(response.getHeaders()), function.getInputType(), mapper);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Event message: " + eventMessage));
            }
            String requestId = response.getHeaders().getFirst("Lambda-Runtime-Aws-Request-Id");
            String invocationUrl = MessageFormat.format(LAMBDA_INVOCATION_URL_TEMPLATE, runtimeApi, LAMBDA_VERSION_DATE, requestId);
            Message responseMessage = (Message)function.apply(eventMessage);
            if (responseMessage != null && logger.isDebugEnabled()) {
                logger.debug((Object)("Reply from function: " + new String((byte[])responseMessage.getPayload(), StandardCharsets.UTF_8)));
            }
            byte[] outputBody = AWSLambdaUtils.generateOutput(eventMessage, (Message<byte[]>)responseMessage, mapper);
            ResponseEntity result = rest.exchange(RequestEntity.post((URI)URI.create(invocationUrl)).body((Object)outputBody), Object.class);
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("Result POST status: " + result.getStatusCode()));
        }
    }

    private static SimpleFunctionRegistry.FunctionInvocationWrapper locateFunction(FunctionCatalog functionCatalog, MediaType contentType) {
        String handlerName = System.getenv("DEFAULT_HANDLER");
        SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(handlerName, new String[]{contentType.toString()});
        if (function == null) {
            handlerName = System.getenv("spring.cloud.function.definition");
        }
        function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(handlerName, new String[]{contentType.toString()});
        Assert.notNull((Object)function, (String)"Failed to locate function. Tried locating default function, function by '_HANDLER' env variable as well as'spring.cloud.function.definition'.");
        if (function != null && logger.isInfoEnabled()) {
            logger.info((Object)("Located function " + function.getFunctionDefinition()));
        }
        return function;
    }

    private static MessageHeaders fromHttp(HttpHeaders headers) {
        LinkedHashMap map = new LinkedHashMap();
        for (String name : headers.keySet()) {
            Collection<?> value;
            Collection<?> values = CustomRuntimeEventLoop.multi(headers.get((Object)name));
            name = name.toLowerCase();
            Collection<?> collection = values == null ? null : (value = values.size() == 1 ? values.iterator().next() : values);
            if (name.toLowerCase().equals("Content-Type".toLowerCase())) {
                name = "contentType";
            }
            map.put(name, value);
        }
        return new MessageHeaders(map);
    }

    private static Collection<?> multi(Object value) {
        return value instanceof Collection ? (List<Object>)value : Arrays.asList(value);
    }
}

