/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

final class AWSLambdaUtils {
    private static Log logger = LogFactory.getLog(AWSLambdaUtils.class);

    private AWSLambdaUtils() {
    }

    public static Message<byte[]> generateMessage(byte[] payload, MessageHeaders headers, Type inputType, ObjectMapper objectMapper) {
        return AWSLambdaUtils.generateMessage(payload, headers, inputType, objectMapper, null);
    }

    public static Message<byte[]> generateMessage(byte[] payload, MessageHeaders headers, Type inputType, ObjectMapper objectMapper, @Nullable Context awsContext) {
        boolean mapInputType;
        Object request;
        if (!objectMapper.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES)) {
            AWSLambdaUtils.configureObjectMapper(objectMapper);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Incoming JSON Event: " + new String(payload)));
        }
        MessageBuilder messageBuilder = null;
        try {
            request = objectMapper.readValue(payload, Object.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (FunctionTypeUtils.isMessage((Type)inputType)) {
            inputType = FunctionTypeUtils.getImmediateGenericType((Type)inputType, (int)0);
        }
        boolean bl = mapInputType = inputType instanceof ParameterizedType && ((Class)((ParameterizedType)inputType).getRawType()).isAssignableFrom(Map.class);
        if (request instanceof Map) {
            Map requestMap = (Map)request;
            if (requestMap.containsKey("Records")) {
                List records = (List)requestMap.get("Records");
                Assert.notEmpty((Collection)records, (String)("Incoming event has no records: " + requestMap));
                AWSLambdaUtils.logEvent(records);
                messageBuilder = MessageBuilder.withPayload((Object)payload);
            } else if (requestMap.containsKey("httpMethod")) {
                logger.info((Object)"Incoming request is API Gateway");
                if (AWSLambdaUtils.isTypeAnApiGatewayRequest(inputType)) {
                    APIGatewayProxyRequestEvent gatewayEvent = (APIGatewayProxyRequestEvent)objectMapper.convertValue((Object)requestMap, APIGatewayProxyRequestEvent.class);
                    messageBuilder = MessageBuilder.withPayload((Object)gatewayEvent);
                } else if (mapInputType) {
                    messageBuilder = MessageBuilder.withPayload((Object)requestMap).setHeader("httpMethod", requestMap.get("httpMethod"));
                } else {
                    Object body = requestMap.remove("body");
                    try {
                        body = body instanceof String ? String.valueOf(body).getBytes(StandardCharsets.UTF_8) : objectMapper.writeValueAsBytes(body);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                    messageBuilder = MessageBuilder.withPayload(body).copyHeaders(requestMap);
                }
            }
        }
        if (messageBuilder == null) {
            messageBuilder = MessageBuilder.withPayload((Object)payload);
        }
        if (awsContext != null) {
            messageBuilder.setHeader("aws-context", (Object)awsContext);
        }
        return messageBuilder.copyHeaders((Map)headers).build();
    }

    public static byte[] generateOutput(Message requestMessage, Message<byte[]> responseMessage, ObjectMapper objectMapper) {
        byte[] responseBytes;
        if (!objectMapper.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES)) {
            AWSLambdaUtils.configureObjectMapper(objectMapper);
        }
        byte[] byArray = responseBytes = responseMessage == null ? "\"OK\"".getBytes() : (byte[])responseMessage.getPayload();
        if (requestMessage.getHeaders().containsKey((Object)"httpMethod") || AWSLambdaUtils.isPayloadAnApiGatewayRequest(requestMessage.getPayload())) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("isBase64Encoded", false);
            AtomicReference<MessageHeaders> headers = new AtomicReference<MessageHeaders>();
            int statusCode = HttpStatus.OK.value();
            if (responseMessage != null) {
                headers.set(responseMessage.getHeaders());
                statusCode = ((MessageHeaders)headers.get()).containsKey((Object)"statusCode") ? ((Integer)((MessageHeaders)headers.get()).get((Object)"statusCode")).intValue() : HttpStatus.OK.value();
            }
            response.put("statusCode", statusCode);
            if (AWSLambdaUtils.isRequestKinesis((Message<Object>)requestMessage)) {
                HttpStatus httpStatus = HttpStatus.valueOf((int)statusCode);
                response.put("statusDescription", httpStatus.toString());
            }
            String body = responseMessage == null ? "\"OK\"" : new String((byte[])responseMessage.getPayload(), StandardCharsets.UTF_8).replaceAll("\\\"", "\"");
            response.put("body", body);
            if (responseMessage != null) {
                HashMap responseHeaders = new HashMap();
                ((MessageHeaders)headers.get()).keySet().forEach(key -> responseHeaders.put(key, ((MessageHeaders)headers.get()).get(key).toString()));
                response.put("headers", responseHeaders);
            }
            try {
                responseBytes = objectMapper.writeValueAsBytes(response);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to serialize AWS Lambda output", e);
            }
        }
        return responseBytes;
    }

    private static void configureObjectMapper(ObjectMapper objectMapper) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Date.class, (JsonDeserializer)new JsonDeserializer<Date>(){

            public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(jsonParser.getValueAsLong());
                return calendar.getTime();
            }
        });
        objectMapper.registerModule((Module)module);
        objectMapper.registerModule((Module)new JodaModule());
        objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
    }

    private static boolean isPayloadAnApiGatewayRequest(Object payload) {
        return AWSLambdaUtils.isAPIGatewayProxyRequestEventPresent() ? payload instanceof APIGatewayProxyRequestEvent : false;
    }

    private static boolean isTypeAnApiGatewayRequest(Type type) {
        return type != null && AWSLambdaUtils.isAPIGatewayProxyRequestEventPresent() ? type.getTypeName().endsWith(APIGatewayProxyRequestEvent.class.getSimpleName()) : false;
    }

    private static boolean isAPIGatewayProxyRequestEventPresent() {
        return ClassUtils.isPresent((String)"com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent", (ClassLoader)ClassUtils.getDefaultClassLoader());
    }

    private static void logEvent(List<Map<String, ?>> records) {
        if (AWSLambdaUtils.isKinesisEvent(records.get(0))) {
            logger.info((Object)"Incoming request is Kinesis Event");
        } else if (AWSLambdaUtils.isS3Event(records.get(0))) {
            logger.info((Object)"Incoming request is S3 Event");
        } else if (AWSLambdaUtils.isSNSEvent(records.get(0))) {
            logger.info((Object)"Incoming request is SNS Event");
        } else {
            logger.info((Object)"Incoming request is SQS Event");
        }
    }

    private static boolean isRequestKinesis(Message<Object> requestMessage) {
        return requestMessage.getHeaders().containsKey((Object)"Records");
    }

    private static boolean isSNSEvent(Map<String, ?> record) {
        return record.containsKey("Sns");
    }

    private static boolean isS3Event(Map<String, ?> record) {
        return record.containsKey("s3");
    }

    private static boolean isKinesisEvent(Map<String, ?> record) {
        return record.containsKey("kinesis");
    }
}

