/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.FunctionalSpringApplication;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.context.config.FunctionContextUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;

public class SpringFunctionInitializer
implements Closeable {
    private static Log logger = LogFactory.getLog(SpringFunctionInitializer.class);
    private final Class<?> configurationClass;
    private Function<Publisher<?>, Publisher<?>> function;
    private AtomicBoolean initialized = new AtomicBoolean();
    @Autowired(required=false)
    private FunctionInspector inspector;
    @Autowired(required=false)
    private FunctionCatalog catalog;
    private ConfigurableApplicationContext context;

    public SpringFunctionInitializer(Class<?> configurationClass) {
        this.configurationClass = configurationClass;
    }

    public SpringFunctionInitializer() {
        this(SpringFunctionInitializer.getStartClass());
    }

    private static Class<?> getStartClass() {
        ClassLoader classLoader = SpringFunctionInitializer.class.getClassLoader();
        if (System.getenv("MAIN_CLASS") != null) {
            return ClassUtils.resolveClassName((String)System.getenv("MAIN_CLASS"), (ClassLoader)classLoader);
        }
        try {
            Class<?> result = SpringFunctionInitializer.getStartClass(Collections.list(classLoader.getResources("META-INF/MANIFEST.MF")));
            if (result == null) {
                result = SpringFunctionInitializer.getStartClass(Collections.list(classLoader.getResources("meta-inf/manifest.mf")));
            }
            logger.info((Object)("Main class: " + result));
            return result;
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to find main class", (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class<?> getStartClass(List<URL> list) {
        logger.info((Object)("Searching manifests: " + list));
        Iterator<URL> iterator = list.iterator();
        while (iterator.hasNext()) {
            URL url = iterator.next();
            try {
                logger.info((Object)("Searching manifest: " + url));
                try (InputStream inputStream = url.openStream();){
                    Manifest manifest = new Manifest(inputStream);
                    String startClass = manifest.getMainAttributes().getValue("Start-Class");
                    if (startClass == null) continue;
                    Class clazz = ClassUtils.forName((String)startClass, (ClassLoader)SpringFunctionInitializer.class.getClassLoader());
                    return clazz;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    @Override
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    protected void initialize() {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        logger.info((Object)("Initializing: " + this.configurationClass));
        SpringApplication builder = this.springApplication();
        this.context = builder.run(new String[0]);
        this.context.getAutowireCapableBeanFactory().autowireBean((Object)this);
        String name = this.context.getEnvironment().getProperty("function.name");
        if (name == null) {
            name = "function";
        }
        if (this.catalog == null) {
            if (this.context.containsBean(name)) {
                this.function = (Function)this.getAndInstrumentFromContext(name);
            }
        } else {
            Set functionNames = this.catalog.getNames(Function.class);
            this.function = functionNames.size() == 1 ? (Function)this.catalog.lookup(Function.class, (String)functionNames.iterator().next()) : (Function)this.catalog.lookup(Function.class, name);
        }
    }

    private <T> T getAndInstrumentFromContext(String name) {
        FunctionRegistration functionRegistration = new FunctionRegistration(this.context.getBean(name), new String[]{name});
        Type type = FunctionContextUtils.findType((String)name, (ConfigurableListableBeanFactory)this.context.getBeanFactory());
        FunctionType functionType = new FunctionType(type);
        return (T)functionRegistration.type(functionType).wrap().getTarget();
    }

    private SpringApplication springApplication() {
        Class<?> sourceClass = this.configurationClass;
        FunctionalSpringApplication application = new FunctionalSpringApplication(new Class[]{sourceClass});
        application.setWebApplicationType(WebApplicationType.NONE);
        return application;
    }

    protected Class<?> getInputType() {
        if (this.inspector != null) {
            return this.inspector.getInputType(this.function());
        }
        return Object.class;
    }

    protected Object function() {
        return this.function;
    }

    protected Publisher<?> apply(Publisher<?> input) {
        if (this.function != null) {
            return Flux.from(this.function.apply(input));
        }
        throw new IllegalStateException("No function defined");
    }
}

