/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.yarn;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.deployer.spi.yarn.AbstractDeployerStateMachine;
import org.springframework.cloud.deployer.spi.yarn.YarnCloudAppService;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.task.TaskExecutor;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.guard.Guard;

public class TaskLauncherStateMachine
extends AbstractDeployerStateMachine {
    private static final Logger logger = LoggerFactory.getLogger(TaskLauncherStateMachine.class);
    private static final String MODEL_LOCATION = "classpath:tasklauncher-model.uml";
    public static final String EVENT_LAUNCH = "LAUNCH";
    public static final String EVENT_CANCEL = "CANCEL";

    public TaskLauncherStateMachine(YarnCloudAppService yarnCloudAppService, TaskExecutor taskExecutor, BeanFactory beanFactory, ResourceLoader resourceLoader) {
        super(yarnCloudAppService, taskExecutor, beanFactory, resourceLoader, MODEL_LOCATION);
    }

    @Override
    protected Map<String, Action<String, String>> getRegisteredActions() {
        HashMap<String, Action<String, String>> actions = new HashMap<String, Action<String, String>>();
        actions.put("resetVariablesAction", new AbstractDeployerStateMachine.ResetVariablesAction());
        actions.put("launchAction", new LaunchAction());
        actions.put("cancelAction", new CancelAction());
        actions.put("checkAppAction", new AbstractDeployerStateMachine.CheckAppAction(YarnCloudAppService.CloudAppType.TASK));
        actions.put("pushAppAction", new AbstractDeployerStateMachine.PushAppAction(YarnCloudAppService.CloudAppType.TASK));
        actions.put("pushArtifactAction", new AbstractDeployerStateMachine.PushArtifactAction());
        actions.put("startAppAction", new StartAppAction());
        actions.put("stopAppAction", new StopAppAction());
        actions.put("errorHandlingAction", new AbstractDeployerStateMachine.ErrorAction());
        return actions;
    }

    @Override
    protected Map<String, Guard<String, String>> getRegisteredGuards() {
        HashMap<String, Guard<String, String>> guards = new HashMap<String, Guard<String, String>>();
        guards.put("pushAppGuard", new AbstractDeployerStateMachine.PushAppGuard());
        guards.put("errorGuard", new AbstractDeployerStateMachine.ErrorGuard());
        return guards;
    }

    private class StopAppAction
    implements Action<String, String> {
        private StopAppAction() {
        }

        public void execute(StateContext<String, String> context) {
            String applicationId = (String)context.getMessageHeader((Object)"applicationId");
            logger.info("Killing application {}", (Object)applicationId);
            TaskLauncherStateMachine.this.getYarnCloudAppService().killApplication(applicationId, YarnCloudAppService.CloudAppType.TASK);
        }
    }

    private class StartAppAction
    implements Action<String, String> {
        private StartAppAction() {
        }

        public void execute(StateContext<String, String> context) {
            String appVersion = (String)context.getMessageHeader((Object)"appVersion");
            List contextRunArgs = (List)context.getMessageHeader((Object)"contextRunArgs");
            String applicationId = TaskLauncherStateMachine.this.getYarnCloudAppService().submitApplication(appVersion, YarnCloudAppService.CloudAppType.TASK, contextRunArgs);
            logger.info("New application id is {}", (Object)applicationId);
            context.getExtendedState().getVariables().put("applicationId", applicationId);
        }
    }

    private class CancelAction
    implements Action<String, String> {
        private CancelAction() {
        }

        public void execute(StateContext<String, String> context) {
            context.getExtendedState().getVariables().put("messageId", context.getMessageHeaders().getId().toString());
        }
    }

    private class LaunchAction
    implements Action<String, String> {
        private LaunchAction() {
        }

        public void execute(StateContext<String, String> context) {
            context.getExtendedState().getVariables().put("messageId", context.getMessageHeaders().getId().toString());
        }
    }
}

