/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.test.AbstractIntegrationTests;
import org.springframework.cloud.deployer.spi.test.EventuallyMatcher;
import org.springframework.cloud.deployer.spi.test.Timeout;
import org.springframework.core.io.Resource;

public abstract class AbstractAppDeployerIntegrationTests
extends AbstractIntegrationTests {
    protected abstract AppDeployer appDeployer();

    @Test
    public void testUnknownDeployment() {
        String unknownId = this.randomName();
        AppStatus status = this.appDeployer().status(unknownId);
        Assert.assertThat((Object)status.getDeploymentId(), (Matcher)Matchers.is((Object)unknownId));
        Assert.assertThat((String)("The map was not empty: " + status.getInstances()), (Object)status.getInstances().isEmpty(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)status.getState(), (Matcher)Matchers.is((Object)DeploymentState.unknown));
    }

    @Test
    public void testSimpleDeployment() {
        AppDefinition definition = new AppDefinition(this.randomName(), null);
        Resource resource = this.testApplication();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource);
        this.log.info("Deploying {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.record(this.appDeployer().deploy(request));
        Timeout timeout = this.deploymentTimeout();
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.deployed))), timeout.maxAttempts, timeout.pause));
        this.log.info("Deploying {} again...", (Object)request.getDefinition().getName());
        try {
            this.appDeployer().deploy(request);
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.unknown))), timeout.maxAttempts, timeout.pause));
    }

    @Test
    public void testRedeploy() {
        AppDefinition definition = new AppDefinition(this.randomName(), null);
        Resource resource = this.testApplication();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource);
        this.log.info("Deploying {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.record(this.appDeployer().deploy(request));
        Timeout timeout = this.deploymentTimeout();
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.deployed))), timeout.maxAttempts, timeout.pause));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.unknown))), timeout.maxAttempts, timeout.pause));
        try {
            Thread.sleep(this.redeploymentPause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.log.info("Deploying {} again...", (Object)request.getDefinition().getName());
        deploymentId = this.record(this.appDeployer().deploy(request));
        timeout = this.deploymentTimeout();
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.deployed))), timeout.maxAttempts, timeout.pause));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.unknown))), timeout.maxAttempts, timeout.pause));
    }

    @Test
    public void testDeployingStateCalculationAndCancel() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("initDelay", "3600000");
        AppDefinition definition = new AppDefinition(this.randomName(), properties);
        Resource resource = this.testApplication();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource, properties);
        this.log.info("Deploying {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.record(this.appDeployer().deploy(request));
        Timeout timeout = this.deploymentTimeout();
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.deploying))), timeout.maxAttempts, timeout.pause));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.unknown))), timeout.maxAttempts, timeout.pause));
    }

    @Test
    public void testFailedDeployment() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("killDelay", "0");
        AppDefinition definition = new AppDefinition(this.randomName(), properties);
        Resource resource = this.testApplication();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource, properties);
        this.log.info("Deploying {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.record(this.appDeployer().deploy(request));
        Timeout timeout = this.deploymentTimeout();
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.failed))), timeout.maxAttempts, timeout.pause));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.unknown))), timeout.maxAttempts, timeout.pause));
    }

    @Test
    public void testApplicationPropertiesPassing() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("parameterThatMayNeedEscaping", "&'\"|< \u00e9\\(");
        AppDefinition definition = new AppDefinition(this.randomName(), properties);
        HashMap<String, String> deploymentProperties = new HashMap<String, String>();
        deploymentProperties.put("killDelay", "0");
        AppDeploymentRequest request = new AppDeploymentRequest(definition, this.testApplication(), deploymentProperties);
        this.log.info("Deploying {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.record(this.appDeployer().deploy(request));
        Timeout timeout = this.deploymentTimeout();
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.deployed))), timeout.maxAttempts, timeout.pause));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.unknown))), timeout.maxAttempts, timeout.pause));
        properties.put("parameterThatMayNeedEscaping", "notWhatIsExpected");
        definition = new AppDefinition(this.randomName(), properties);
        request = new AppDeploymentRequest(definition, this.testApplication(), deploymentProperties);
        this.log.info("Deploying {}, expecting it to fail...", (Object)request.getDefinition().getName());
        deploymentId = this.record(this.appDeployer().deploy(request));
        timeout = this.deploymentTimeout();
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.failed))), timeout.maxAttempts, timeout.pause));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.unknown))), timeout.maxAttempts, timeout.pause));
    }

    @Test
    public void testCommandLineArgumentsPassing() {
        HashMap properties = new HashMap();
        AppDefinition definition = new AppDefinition(this.randomName(), properties);
        HashMap deploymentProperties = new HashMap();
        List<String> cmdLineArgs = Arrays.asList("--commandLineArgValueThatMayNeedEscaping=&'\"|< \u00e9\\(");
        AppDeploymentRequest request = new AppDeploymentRequest(definition, this.testApplication(), deploymentProperties, cmdLineArgs);
        this.log.info("Deploying {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.record(this.appDeployer().deploy(request));
        Timeout timeout = this.deploymentTimeout();
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.deployed))), timeout.maxAttempts, timeout.pause));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.unknown))), timeout.maxAttempts, timeout.pause));
        properties = new HashMap();
        definition = new AppDefinition(this.randomName(), properties);
        deploymentProperties = new HashMap();
        cmdLineArgs = Arrays.asList("--commandLineArgValueThatMayNeedEscaping=notWhatIsExpected");
        request = new AppDeploymentRequest(definition, this.testApplication(), deploymentProperties, cmdLineArgs);
        this.log.info("Deploying {}, expecting it to fail...", (Object)request.getDefinition().getName());
        deploymentId = this.record(this.appDeployer().deploy(request));
        timeout = this.deploymentTimeout();
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.failed))), timeout.maxAttempts, timeout.pause));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.unknown))), timeout.maxAttempts, timeout.pause));
    }

    @Test
    public void testMultipleInstancesDeploymentAndPartialState() {
        HashMap<String, String> appProperties = new HashMap<String, String>();
        appProperties.put("matchInstances", "1");
        appProperties.put("killDelay", "0");
        AppDefinition definition = new AppDefinition(this.randomName(), appProperties);
        Resource resource = this.testApplication();
        HashMap<String, String> deploymentProperties = new HashMap<String, String>();
        deploymentProperties.put("spring.cloud.deployer.count", "3");
        deploymentProperties.put("spring.cloud.deployer.indexed", "true");
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource, deploymentProperties);
        this.log.info("Deploying {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.record(this.appDeployer().deploy(request));
        Timeout timeout = this.deploymentTimeout();
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.partial))), timeout.maxAttempts, timeout.pause));
        ArrayList<DeploymentState> individualStates = new ArrayList<DeploymentState>();
        for (AppInstanceStatus status : this.appDeployer().status(deploymentId).getInstances().values()) {
            individualStates.add(status.getState());
        }
        Assert.assertThat(individualStates, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.is((Object)DeploymentState.deployed), Matchers.is((Object)DeploymentState.deployed), Matchers.is((Object)DeploymentState.failed)}));
        this.log.info("Undeploying {}...", (Object)deploymentId);
        timeout = this.undeploymentTimeout();
        this.appDeployer().undeploy(deploymentId);
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<AppStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)DeploymentState.unknown))), timeout.maxAttempts, timeout.pause));
    }

    protected Matcher<String> hasStatusThat(final Matcher<AppStatus> statusMatcher) {
        return new BaseMatcher<String>(){
            private AppStatus status;

            public boolean matches(Object item) {
                this.status = AbstractAppDeployerIntegrationTests.this.appDeployer().status((String)item);
                return statusMatcher.matches((Object)this.status);
            }

            public void describeMismatch(Object item, Description mismatchDescription) {
                mismatchDescription.appendText("status of ").appendValue(item).appendText(" ");
                statusMatcher.describeMismatch((Object)this.status, mismatchDescription);
            }

            public void describeTo(Description description) {
                statusMatcher.describeTo(description);
            }
        };
    }
}

