/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.resource.docker;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.springframework.core.io.AbstractResource;
import org.springframework.util.Assert;

public class DockerResource
extends AbstractResource {
    public static final String URI_SCHEME = "docker";
    private URI uri;

    public DockerResource(String imageName) {
        Assert.hasText((String)imageName, (String)"An image name is required");
        this.uri = URI.create("docker:" + imageName);
    }

    public DockerResource(URI uri) {
        Assert.notNull((Object)uri, (String)"A URI is required");
        Assert.isTrue((boolean)URI_SCHEME.equals(uri.getScheme()), (String)"A 'docker' scheme is required");
        this.uri = uri;
    }

    public String getDescription() {
        return "Docker Resource [" + this.uri + "]";
    }

    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("getInputStream not supported");
    }

    public URI getURI() throws IOException {
        return this.uri;
    }
}

