/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.mesos.marathon;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import mesosphere.marathon.client.Marathon;
import mesosphere.marathon.client.model.v2.App;
import mesosphere.marathon.client.model.v2.Container;
import mesosphere.marathon.client.model.v2.Docker;
import mesosphere.marathon.client.model.v2.Group;
import mesosphere.marathon.client.model.v2.HealthCheck;
import mesosphere.marathon.client.model.v2.Port;
import mesosphere.marathon.client.model.v2.Task;
import mesosphere.marathon.client.utils.MarathonException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.mesos.marathon.MarathonAppDeployerProperties;
import org.springframework.cloud.deployer.spi.mesos.marathon.MarathonAppInstanceStatus;
import org.springframework.util.Assert;

public class MarathonAppDeployer
implements AppDeployer {
    private static final Log logger = LogFactory.getLog(MarathonAppDeployer.class);
    private MarathonAppDeployerProperties properties = new MarathonAppDeployerProperties();
    Marathon marathon;

    @Autowired
    public MarathonAppDeployer(MarathonAppDeployerProperties properties, Marathon marathon) {
        this.properties = properties;
        this.marathon = marathon;
    }

    public String deploy(AppDeploymentRequest request) {
        logger.info((Object)String.format("Deploying app: %s", request.getDefinition().getName()));
        String appId = this.deduceAppId(request);
        boolean indexed = Boolean.valueOf((String)request.getDeploymentProperties().get("spring.cloud.deployer.indexed"));
        if (indexed) {
            try {
                Group group = this.marathon.getGroup(appId);
                throw new IllegalStateException(String.format("App '%s' is already deployed", request.getDefinition().getName()));
            }
            catch (MarathonException group) {
                Container container = this.createContainer(request);
                String countProperty = (String)request.getDeploymentProperties().get("spring.cloud.deployer.count");
                int count = countProperty != null ? Integer.parseInt(countProperty) : 1;
                for (int i = 0; i < count; ++i) {
                    String instanceId = appId + "/" + request.getDefinition().getName() + "-" + i;
                    this.createAppDeployment(request, instanceId, container, i);
                }
            }
        } else {
            AppStatus status = this.status(appId);
            if (!status.getState().equals((Object)DeploymentState.unknown)) {
                throw new IllegalStateException(String.format("App '%s' is already deployed", request.getDefinition().getName()));
            }
            Container container = this.createContainer(request);
            this.createAppDeployment(request, appId, container, null);
        }
        return appId;
    }

    private void createAppDeployment(AppDeploymentRequest request, String deploymentId, Container container, Integer index) {
        App app = new App();
        app.setContainer(container);
        app.setId(deploymentId);
        HashMap<String, String> env = new HashMap<String, String>();
        env.putAll(request.getDefinition().getProperties());
        for (String envVar : this.properties.getEnvironmentVariables()) {
            String[] strings = envVar.split("=", 2);
            Assert.isTrue((strings.length == 2 ? 1 : 0) != 0, (String)("Invalid environment variable declared: " + envVar));
            env.put(strings[0], strings[1]);
        }
        if (index != null) {
            env.put("INSTANCE_INDEX", index.toString());
        }
        app.setEnv(env);
        Double cpus = this.deduceCpus(request);
        Double memory = this.deduceMemory(request);
        Integer instances = index == null ? this.deduceInstances(request) : 1;
        app.setCpus(cpus);
        app.setMem(memory);
        app.setInstances(instances);
        HealthCheck healthCheck = new HealthCheck();
        healthCheck.setPath("/health");
        healthCheck.setGracePeriodSeconds(Integer.valueOf(300));
        app.setHealthChecks(Arrays.asList(healthCheck));
        logger.debug((Object)("Creating app with definition:\n" + app.toString()));
        try {
            this.marathon.createApp(app);
        }
        catch (MarathonException e) {
            throw new RuntimeException(e);
        }
    }

    private Container createContainer(AppDeploymentRequest request) {
        Container container = new Container();
        Docker docker = new Docker();
        String image = null;
        try {
            image = request.getResource().getURI().getSchemeSpecificPart();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to get URI for " + request.getResource(), e);
        }
        logger.info((Object)("Using Docker image: " + image));
        docker.setImage(image);
        Port port = new Port(Integer.valueOf(8080));
        port.setHostPort(Integer.valueOf(0));
        docker.setPortMappings(Arrays.asList(port));
        docker.setNetwork("BRIDGE");
        container.setDocker(docker);
        return container;
    }

    public void undeploy(String id) {
        logger.info((Object)String.format("Undeploying app: %s", id));
        Group group = null;
        try {
            group = this.marathon.getGroup(id);
        }
        catch (MarathonException marathonException) {
            // empty catch block
        }
        if (group != null) {
            logger.info((Object)String.format("Undeploying application deployments for group: %s", group.getId()));
            try {
                if (group.getGroups().size() > 0) {
                    for (Group g : group.getGroups()) {
                        this.deleteAppsForGroupDeployment(g.getId());
                    }
                }
                this.deleteAppsForGroupDeployment(group.getId());
            }
            catch (MarathonException e) {
                throw new RuntimeException(e);
            }
        } else {
            logger.info((Object)String.format("Undeploying application deployment: %s", id));
            try {
                App app = this.marathon.getApp(id).getApp();
                logger.debug((Object)String.format("Deleting application: %s", app.getId()));
                this.marathon.deleteApp(id);
                this.deleteTopLevelGroupForDeployment(id);
            }
            catch (MarathonException e) {
                if (e.getMessage().contains("Not Found")) {
                    logger.debug((Object)String.format("Caught: %s", e.getMessage()));
                    try {
                        this.deleteAppsForGroupDeployment(id);
                    }
                    catch (MarathonException e2) {
                        throw new RuntimeException(e2);
                    }
                }
                throw new RuntimeException(e);
            }
        }
    }

    private void deleteAppsForGroupDeployment(String groupId) throws MarathonException {
        Group group = this.marathon.getGroup(groupId);
        for (App app : group.getApps()) {
            logger.debug((Object)String.format("Deleting application %s in group %s", app.getId(), groupId));
            this.marathon.deleteApp(app.getId());
        }
        group = this.marathon.getGroup(groupId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Group %s has %d applications and %d groups", group.getId(), group.getApps().size(), group.getGroups().size()));
        }
        if (group.getApps().size() == 0 && group.getGroups().size() == 0) {
            logger.info((Object)String.format("Deleting group: %s", groupId));
            this.marathon.deleteGroup(groupId);
        }
        this.deleteTopLevelGroupForDeployment(groupId);
    }

    private void deleteTopLevelGroupForDeployment(String id) throws MarathonException {
        String topLevelGroupId = this.extractGroupId(id);
        if (topLevelGroupId != null) {
            Group topGroup = this.marathon.getGroup(topLevelGroupId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Top level group %s has %d applications and %d groups", topGroup.getId(), topGroup.getApps().size(), topGroup.getGroups().size()));
            }
            if (topGroup.getApps().size() == 0 && topGroup.getGroups().size() == 0) {
                logger.info((Object)String.format("Deleting group: %s", topLevelGroupId));
                this.marathon.deleteGroup(topLevelGroupId);
            }
        }
    }

    public AppStatus status(String id) {
        AppStatus status;
        try {
            App app = this.marathon.getApp(id).getApp();
            logger.debug((Object)String.format("Building status for app: %s", id));
            status = this.buildAppStatus(id, app);
        }
        catch (MarathonException e) {
            if (e.getMessage().contains("Not Found")) {
                try {
                    Group group = this.marathon.getGroup(id);
                    logger.debug((Object)String.format("Building status for group: %s", id));
                    AppStatus.Builder result = AppStatus.of((String)id);
                    for (App app : group.getApps()) {
                        result.with(this.buildInstanceStatus(app.getId()));
                    }
                    status = result.build();
                }
                catch (MarathonException e1) {
                    status = AppStatus.of((String)id).build();
                }
            }
            status = AppStatus.of((String)id).build();
        }
        logger.debug((Object)String.format("Status for app: %s is %s", id, status));
        return status;
    }

    private String deduceAppId(AppDeploymentRequest request) {
        String groupId = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        String name = request.getDefinition().getName();
        if (groupId != null) {
            return "/" + groupId + "/" + name;
        }
        return "/" + name;
    }

    private String extractGroupId(String appId) {
        int index = appId.lastIndexOf(47);
        String groupId = null;
        if (index > 0) {
            groupId = appId.substring(0, index);
        }
        return groupId;
    }

    private Double deduceMemory(AppDeploymentRequest request) {
        String override = (String)request.getDeploymentProperties().get("spring.cloud.deployer.marathon.memory");
        return override != null ? Double.valueOf(override).doubleValue() : this.properties.getMemory();
    }

    private Double deduceCpus(AppDeploymentRequest request) {
        String override = (String)request.getDeploymentProperties().get("spring.cloud.deployer.marathon.cpu");
        return override != null ? Double.valueOf(override).doubleValue() : this.properties.getCpu();
    }

    private Integer deduceInstances(AppDeploymentRequest request) {
        String value = (String)request.getDeploymentProperties().get("spring.cloud.deployer.count");
        return value != null ? Integer.valueOf(value) : Integer.valueOf("1");
    }

    private AppInstanceStatus buildInstanceStatus(String id) throws MarathonException {
        App appInstance = this.marathon.getApp(id).getApp();
        logger.debug((Object)("Deployment " + id + " has " + appInstance.getTasksRunning() + "/" + appInstance.getInstances() + " tasks running"));
        if (appInstance.getTasks() != null) {
            MarathonAppInstanceStatus status = null;
            for (Task task : appInstance.getTasks()) {
                if (status != null) continue;
                status = MarathonAppInstanceStatus.up(appInstance, task);
            }
            if (status == null) {
                status = MarathonAppInstanceStatus.down(appInstance);
            }
            return status;
        }
        return MarathonAppInstanceStatus.down(appInstance);
    }

    private AppStatus buildAppStatus(String id, App app) {
        logger.debug((Object)("Deployment " + id + " has " + app.getTasksRunning() + "/" + app.getInstances() + " tasks running"));
        AppStatus.Builder result = AppStatus.of((String)id);
        int requestedInstances = app.getInstances();
        int actualInstances = 0;
        if (app.getTasks() != null) {
            for (Task task : app.getTasks()) {
                result.with((AppInstanceStatus)MarathonAppInstanceStatus.up(app, task));
                ++actualInstances;
            }
        }
        for (int i = actualInstances; i < requestedInstances; ++i) {
            result.with((AppInstanceStatus)MarathonAppInstanceStatus.down(app));
        }
        return result.build();
    }
}

