/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.mesos;

import feign.RequestInterceptor;
import mesosphere.marathon.client.Marathon;
import mesosphere.marathon.client.MarathonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.mesos.chronos.ChronosTaskLauncher;
import org.springframework.cloud.deployer.spi.mesos.chronos.ChronosTaskLauncherProperties;
import org.springframework.cloud.deployer.spi.mesos.dcos.DcosClusterProperties;
import org.springframework.cloud.deployer.spi.mesos.marathon.MarathonAppDeployer;
import org.springframework.cloud.deployer.spi.mesos.marathon.MarathonAppDeployerProperties;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.mesos.chronos.client.Chronos;
import org.springframework.cloud.mesos.chronos.client.ChronosClient;
import org.springframework.cloud.mesos.dcos.client.DcosHeadersInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={MarathonAppDeployerProperties.class, ChronosTaskLauncherProperties.class, DcosClusterProperties.class})
@AutoConfigureOrder(value=-2147483648)
public class MesosAutoConfiguration {
    @Autowired
    private MarathonAppDeployerProperties marathonProperties;
    @Autowired
    private ChronosTaskLauncherProperties chronosProperties;
    @Autowired
    private DcosClusterProperties dcosClusterProperties;

    @Bean
    @RefreshScope
    public Marathon marathon() {
        if (StringUtils.hasText((String)this.dcosClusterProperties.getAuthorizationToken())) {
            return MarathonClient.getInstance((String)this.marathonProperties.getApiEndpoint(), (RequestInterceptor[])new RequestInterceptor[]{new DcosHeadersInterceptor(this.dcosClusterProperties.getAuthorizationToken())});
        }
        return MarathonClient.getInstance((String)this.marathonProperties.getApiEndpoint());
    }

    @Bean
    @RefreshScope
    public AppDeployer appDeployer(Marathon marathon) {
        return new MarathonAppDeployer(this.marathonProperties, marathon);
    }

    @Bean
    @RefreshScope
    public Chronos chronos() {
        if (StringUtils.hasText((String)this.dcosClusterProperties.getAuthorizationToken())) {
            return ChronosClient.getInstance(this.chronosProperties.getApiEndpoint(), new DcosHeadersInterceptor(this.dcosClusterProperties.getAuthorizationToken()));
        }
        return ChronosClient.getInstance(this.chronosProperties.getApiEndpoint());
    }

    @Bean
    @RefreshScope
    public TaskLauncher taskDeployer(Chronos chronos) {
        return new ChronosTaskLauncher(this.chronosProperties, chronos);
    }
}

