/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.mesos;

import mesosphere.marathon.client.Marathon;
import mesosphere.marathon.client.MarathonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.mesos.chronos.ChronosTaskLauncher;
import org.springframework.cloud.deployer.spi.mesos.chronos.ChronosTaskLauncherProperties;
import org.springframework.cloud.deployer.spi.mesos.marathon.MarathonAppDeployer;
import org.springframework.cloud.deployer.spi.mesos.marathon.MarathonAppDeployerProperties;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.mesos.chronos.client.Chronos;
import org.springframework.cloud.mesos.chronos.client.ChronosClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={MarathonAppDeployerProperties.class, ChronosTaskLauncherProperties.class})
@AutoConfigureOrder(value=-2147483648)
public class MesosAutoConfiguration {
    @Autowired
    private MarathonAppDeployerProperties marathonProperties;
    @Autowired
    private ChronosTaskLauncherProperties chronosProperties;

    @Bean
    public Marathon marathon() {
        Marathon marathon = MarathonClient.getInstance((String)this.marathonProperties.getApiEndpoint());
        return marathon;
    }

    @Bean
    public AppDeployer appDeployer(Marathon marathon) {
        return new MarathonAppDeployer(this.marathonProperties, marathon);
    }

    @Bean
    public Chronos chronos() {
        Chronos chronos = ChronosClient.getInstance(this.chronosProperties.getApiEndpoint());
        return chronos;
    }

    @Bean
    public TaskLauncher taskDeployer(Chronos chronos) {
        return new ChronosTaskLauncher(this.chronosProperties, chronos);
    }
}

