/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.AppScaleRequest;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.local.AbstractLocalDeployerSupport;
import org.springframework.cloud.deployer.spi.local.HttpProbeExecutor;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class LocalAppDeployer
extends AbstractLocalDeployerSupport
implements AppDeployer {
    private static final Logger logger = LoggerFactory.getLogger(LocalAppDeployer.class);
    private static final String JMX_DEFAULT_DOMAIN_KEY = "spring.jmx.default-domain";
    private static final String ENDPOINTS_SHUTDOWN_ENABLED_KEY = "endpoints.shutdown.enabled";
    private final Map<String, AppInstancesHolder> running = new ConcurrentHashMap<String, AppInstancesHolder>();

    public LocalAppDeployer(LocalDeployerProperties properties) {
        super(properties);
    }

    private static Integer getProcessExitValue(Process process) {
        try {
            return process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            return null;
        }
    }

    private static synchronized int getLocalProcessPid(Process p) {
        int pid = 0;
        try {
            if (p.getClass().getName().equals("java.lang.UNIXProcess")) {
                Field f = p.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                pid = f.getInt(p);
                f.setAccessible(false);
            }
        }
        catch (Exception e) {
            pid = 0;
        }
        return pid;
    }

    public String deploy(AppDeploymentRequest request) {
        String group = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        String deploymentId = String.format("%s.%s", group, request.getDefinition().getName());
        this.validateStatus(deploymentId, DeploymentState.unknown);
        ArrayList<AppInstance> processes = new ArrayList<AppInstance>();
        this.running.put(deploymentId, new AppInstancesHolder(processes, request));
        try {
            Path workDir = this.createWorkingDir(request.getDeploymentProperties(), deploymentId);
            String countProperty = (String)request.getDeploymentProperties().get("spring.cloud.deployer.count");
            int count = StringUtils.hasText((String)countProperty) ? Integer.parseInt(countProperty) : 1;
            for (int index = 0; index < count; ++index) {
                processes.add(this.deployApp(request, workDir, group, deploymentId, index, request.getDeploymentProperties()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Exception trying to deploy " + request, e);
        }
        return deploymentId;
    }

    public void scale(AppScaleRequest appScaleRequest) {
        List<AppInstance> instances;
        this.validateStatus(appScaleRequest.getDeploymentId(), DeploymentState.deployed);
        AppInstancesHolder holder = this.running.get(appScaleRequest.getDeploymentId());
        List<AppInstance> list = instances = holder != null ? holder.instances : null;
        if (instances == null) {
            throw new IllegalStateException("Can't find existing instances for deploymentId " + appScaleRequest.getDeploymentId());
        }
        AppDeploymentRequest request = holder.request;
        String group = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        String deploymentId = String.format("%s.%s", group, request.getDefinition().getName());
        try {
            Path workDir = this.createWorkingDir(request.getDeploymentProperties(), deploymentId);
            int deltaCount = appScaleRequest.getCount() - instances.size();
            int targetCount = instances.size() + deltaCount;
            if (deltaCount > 0) {
                for (int index = instances.size(); index < targetCount; ++index) {
                    instances.add(this.deployApp(request, workDir, group, deploymentId, index, request.getDeploymentProperties()));
                }
            } else if (deltaCount < 0) {
                ArrayList<AppInstance> processes = new ArrayList<AppInstance>();
                for (int index = instances.size() - 1; index >= targetCount; --index) {
                    processes.add(instances.remove(index));
                }
                for (AppInstance instance : processes) {
                    if (!this.isAlive(instance.getProcess())) continue;
                    logger.info("Un-deploying app with deploymentId {} instance {}.", (Object)deploymentId, (Object)instance.getInstanceNumber());
                    this.shutdownAndWait(instance);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Exception trying to deploy " + request, e);
        }
    }

    public void undeploy(String id) {
        List<AppInstance> processes;
        AppInstancesHolder holder = this.running.get(id);
        List<AppInstance> list = processes = holder != null ? holder.instances : null;
        if (processes != null) {
            for (AppInstance instance : processes) {
                if (!this.isAlive(instance.getProcess())) continue;
                logger.info("Un-deploying app with deploymentId {} instance {}.", (Object)id, (Object)instance.getInstanceNumber());
                this.shutdownAndWait(instance);
            }
        } else {
            throw new IllegalStateException(String.format("App with deploymentId %s is not in a deployed state.", id));
        }
        this.running.remove(id);
    }

    public AppStatus status(String id) {
        AppInstancesHolder holder = this.running.get(id);
        List<AppInstance> instances = holder != null ? holder.instances : null;
        AppStatus.Builder builder = AppStatus.of((String)id);
        if (instances != null) {
            for (AppInstance instance : instances) {
                builder.with((AppInstanceStatus)instance);
            }
        }
        return builder.build();
    }

    public String getLog(String id) {
        AppInstancesHolder holder = this.running.get(id);
        List<AppInstance> instances = holder != null ? holder.instances : null;
        StringBuilder stringBuilder = new StringBuilder();
        if (instances != null) {
            for (AppInstance instance : instances) {
                String stdout;
                String stderr = instance.getStdErr();
                if (StringUtils.hasText((String)stderr)) {
                    stringBuilder.append("stderr:\n");
                    stringBuilder.append(stderr);
                }
                if (!StringUtils.hasText((String)(stdout = instance.getStdOut()))) continue;
                stringBuilder.append("stdout:\n");
                stringBuilder.append(stdout);
            }
        }
        return stringBuilder.toString();
    }

    public RuntimeEnvironmentInfo environmentInfo() {
        return super.createRuntimeEnvironmentInfo(AppDeployer.class, this.getClass());
    }

    @PreDestroy
    public void shutdown() {
        for (String deploymentId : this.running.keySet()) {
            this.undeploy(deploymentId);
        }
    }

    private AppInstance deployApp(AppDeploymentRequest request, Path workDir, String group, String deploymentId, int index, Map<String, String> deploymentProperties) throws IOException {
        LocalDeployerProperties localDeployerPropertiesToUse = this.bindDeploymentProperties(deploymentProperties);
        HashMap<String, String> consolidatedAppProperties = new HashMap<String, String>(request.getDefinition().getProperties());
        consolidatedAppProperties.put(JMX_DEFAULT_DOMAIN_KEY, deploymentId);
        if (!request.getDefinition().getProperties().containsKey(ENDPOINTS_SHUTDOWN_ENABLED_KEY)) {
            consolidatedAppProperties.put(ENDPOINTS_SHUTDOWN_ENABLED_KEY, "true");
        }
        consolidatedAppProperties.put("endpoints.jmx.unique-names", "true");
        if (group != null) {
            consolidatedAppProperties.put("spring.cloud.application.group", group);
        }
        HashMap<String, String> appInstanceEnv = new HashMap<String, String>(consolidatedAppProperties);
        String guid = LocalAppDeployer.toGuid(deploymentId, index);
        if (this.useSpringApplicationJson(request)) {
            appInstanceEnv.put("instance.index", Integer.toString(index));
            appInstanceEnv.put("spring.cloud.stream.instanceIndex", Integer.toString(index));
            appInstanceEnv.put("spring.application.index", Integer.toString(index));
            appInstanceEnv.put("spring.cloud.application.guid", guid);
        } else {
            appInstanceEnv.put("INSTANCE_INDEX", Integer.toString(index));
            appInstanceEnv.put("SPRING_APPLICATION_INDEX", Integer.toString(index));
            appInstanceEnv.put("SPRING_CLOUD_APPLICATION_GUID", guid);
        }
        boolean useDynamicPort = !request.getDefinition().getProperties().containsKey("server.port");
        int port = this.calcServerPort(request, useDynamicPort, appInstanceEnv);
        ProcessBuilder builder = this.buildProcessBuilder(request, appInstanceEnv, Optional.of(index), deploymentId).inheritIO();
        builder.directory(workDir.toFile());
        URL baseUrl = StringUtils.hasText((String)localDeployerPropertiesToUse.getHostname()) ? new URL("http", localDeployerPropertiesToUse.getHostname(), port, "") : this.getCommandBuilder(request).getBaseUrl(deploymentId, index, port);
        AppInstance instance = new AppInstance(deploymentId, index, port, baseUrl, localDeployerPropertiesToUse.getStartupProbe(), localDeployerPropertiesToUse.getHealthProbe());
        if (this.shouldInheritLogging(request)) {
            instance.start(builder, workDir);
            logger.info("Deploying app with deploymentId {} instance {}.\n   Logs will be inherited.", (Object)deploymentId, (Object)index);
        } else {
            instance.start(builder, workDir, this.getLocalDeployerProperties().isDeleteFilesOnExit());
            logger.info("Deploying app with deploymentId {} instance {}.\n   Logs will be in {}", new Object[]{deploymentId, index, workDir});
        }
        return instance;
    }

    private Path createWorkingDir(Map<String, String> deploymentProperties, String deploymentId) throws IOException {
        LocalDeployerProperties localDeployerPropertiesToUse = this.bindDeploymentProperties(deploymentProperties);
        Path workingDirectoryRoot = Files.createDirectories(localDeployerPropertiesToUse.getWorkingDirectoriesRoot(), new FileAttribute[0]);
        Path workDir = Files.createDirectories(workingDirectoryRoot.resolve(Long.toString(System.currentTimeMillis())).resolve(deploymentId), new FileAttribute[0]);
        if (this.getLocalDeployerProperties().isDeleteFilesOnExit()) {
            workDir.toFile().deleteOnExit();
        }
        return workDir;
    }

    private void validateStatus(String deploymentId, DeploymentState expectedState) {
        DeploymentState state = this.status(deploymentId).getState();
        Assert.state((state == expectedState ? 1 : 0) != 0, (String)String.format("App with deploymentId [%s] with state [%s] doesn't match expected state [%s]", deploymentId, state, expectedState));
    }

    private static String toGuid(String deploymentId, int appIndex) {
        return String.format("%s-%s", deploymentId, appIndex);
    }

    private static class AppInstancesHolder {
        final List<AppInstance> instances;
        final AppDeploymentRequest request;

        public AppInstancesHolder(List<AppInstance> instances, AppDeploymentRequest request) {
            this.instances = instances;
            this.request = request;
        }
    }

    private static class AppInstance
    implements AbstractLocalDeployerSupport.Instance,
    AppInstanceStatus {
        private final String deploymentId;
        private final int instanceNumber;
        private final URL baseUrl;
        private final Map<String, String> attributes = new TreeMap<String, String>();
        private int pid;
        private Process process;
        private File workFile;
        private File stdout;
        private File stderr;
        private int port;
        private HttpProbeExecutor startupProbeExecutor;
        private HttpProbeExecutor healthProbeExecutor;
        private boolean startupProbeOk;

        private AppInstance(String deploymentId, int instanceNumber, int port, URL baseUrl, LocalDeployerProperties.HttpProbe startupProbe, LocalDeployerProperties.HttpProbe healthProbe) {
            this.deploymentId = deploymentId;
            this.instanceNumber = instanceNumber;
            this.port = port;
            this.baseUrl = baseUrl;
            this.attributes.put("port", Integer.toString(port));
            this.attributes.put("guid", LocalAppDeployer.toGuid(deploymentId, instanceNumber));
            this.attributes.put("url", baseUrl.toString());
            this.startupProbeExecutor = HttpProbeExecutor.from(baseUrl, startupProbe);
            this.healthProbeExecutor = HttpProbeExecutor.from(baseUrl, healthProbe);
        }

        public String getId() {
            return this.deploymentId + "-" + this.instanceNumber;
        }

        @Override
        public URL getBaseUrl() {
            return this.baseUrl;
        }

        @Override
        public Process getProcess() {
            return this.process;
        }

        public String toString() {
            return String.format("%s [%s]", this.getId(), this.getState());
        }

        public DeploymentState getState() {
            Integer exit = LocalAppDeployer.getProcessExitValue(this.process);
            if (exit != null) {
                return DeploymentState.failed;
            }
            if (this.port < 1) {
                return DeploymentState.deployed;
            }
            if (this.startupProbeExecutor != null && !this.startupProbeOk) {
                boolean ok = this.startupProbeExecutor.probe();
                if (ok) {
                    this.startupProbeOk = true;
                    return DeploymentState.deployed;
                }
                return DeploymentState.deploying;
            }
            if (this.healthProbeExecutor != null) {
                return this.healthProbeExecutor.probe() ? DeploymentState.deployed : DeploymentState.failed;
            }
            try {
                HttpURLConnection urlConnection = (HttpURLConnection)this.baseUrl.openConnection();
                urlConnection.setConnectTimeout(100);
                urlConnection.connect();
                urlConnection.disconnect();
                return DeploymentState.deployed;
            }
            catch (IOException e) {
                return DeploymentState.deploying;
            }
        }

        public String getStdOut() {
            try {
                return FileCopyUtils.copyToString((Reader)new InputStreamReader(new FileInputStream(this.stdout)));
            }
            catch (IOException e) {
                return "Log retrieval returned " + e.getMessage();
            }
        }

        public String getStdErr() {
            try {
                return FileCopyUtils.copyToString((Reader)new InputStreamReader(new FileInputStream(this.stderr)));
            }
            catch (IOException e) {
                return "Log retrieval returned " + e.getMessage();
            }
        }

        public int getInstanceNumber() {
            return this.instanceNumber;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        private void start(ProcessBuilder builder, Path workDir) throws IOException {
            if (logger.isDebugEnabled()) {
                logger.debug("Local App Deployer Commands: " + String.join((CharSequence)",", builder.command()) + ", Environment: " + builder.environment());
            }
            this.workFile = workDir.toFile();
            this.attributes.put("working.dir", this.workFile.getAbsolutePath());
            this.process = builder.start();
            this.pid = LocalAppDeployer.getLocalProcessPid(this.process);
            if (this.pid > 0) {
                this.attributes.put("pid", Integer.toString(this.pid));
            }
        }

        private void start(ProcessBuilder builder, Path workDir, boolean deleteOnExit) throws IOException {
            String workDirPath = workDir.toFile().getAbsolutePath();
            this.stdout = Files.createFile(Paths.get(workDirPath, "stdout_" + this.instanceNumber + ".log"), new FileAttribute[0]).toFile();
            this.attributes.put("stdout", this.stdout.getAbsolutePath());
            this.stderr = Files.createFile(Paths.get(workDirPath, "stderr_" + this.instanceNumber + ".log"), new FileAttribute[0]).toFile();
            this.attributes.put("stderr", this.stderr.getAbsolutePath());
            if (deleteOnExit) {
                this.stdout.deleteOnExit();
                this.stderr.deleteOnExit();
            }
            builder.redirectOutput(ProcessBuilder.Redirect.to(this.stdout));
            builder.redirectError(ProcessBuilder.Redirect.to(this.stderr));
            this.start(builder, workDir);
        }
    }
}

