/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.kubernetes.DefaultRunningPhaseDeploymentStateResolver;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.RunningPhaseDeploymentStateResolver;

public class KubernetesAppInstanceStatus
implements AppInstanceStatus {
    private static Log logger = LogFactory.getLog(KubernetesAppInstanceStatus.class);
    private final Pod pod;
    private final Service service;
    private final KubernetesDeployerProperties properties;
    private ContainerStatus containerStatus;
    private RunningPhaseDeploymentStateResolver runningPhaseDeploymentStateResolver;

    @Deprecated
    public KubernetesAppInstanceStatus(Pod pod, Service service, KubernetesDeployerProperties properties) {
        this.pod = pod;
        this.service = service;
        this.properties = properties;
        this.containerStatus = pod != null && pod.getStatus().getContainerStatuses().size() == 1 ? (ContainerStatus)pod.getStatus().getContainerStatuses().get(0) : null;
        this.runningPhaseDeploymentStateResolver = new DefaultRunningPhaseDeploymentStateResolver(properties);
    }

    public KubernetesAppInstanceStatus(Pod pod, Service service, KubernetesDeployerProperties properties, ContainerStatus containerStatus) {
        this.pod = pod;
        this.service = service;
        this.properties = properties;
        this.containerStatus = containerStatus;
        this.runningPhaseDeploymentStateResolver = new DefaultRunningPhaseDeploymentStateResolver(properties);
    }

    public void setRunningPhaseDeploymentStateResolver(RunningPhaseDeploymentStateResolver runningPhaseDeploymentStateResolver) {
        this.runningPhaseDeploymentStateResolver = runningPhaseDeploymentStateResolver;
    }

    public String getId() {
        return this.pod == null ? "N/A" : this.pod.getMetadata().getName();
    }

    public DeploymentState getState() {
        return this.pod != null && this.containerStatus != null ? this.mapState() : DeploymentState.unknown;
    }

    private DeploymentState mapState() {
        logger.debug((Object)String.format("%s - Phase [ %s ]", this.pod.getMetadata().getName(), this.pod.getStatus().getPhase()));
        logger.debug((Object)String.format("%s - ContainerStatus [ %s ]", this.pod.getMetadata().getName(), this.containerStatus));
        switch (this.pod.getStatus().getPhase()) {
            case "Pending": {
                return DeploymentState.deploying;
            }
            case "Running": {
                return this.runningPhaseDeploymentStateResolver.resolve(this.containerStatus);
            }
            case "Failed": {
                return DeploymentState.failed;
            }
            case "Unknown": {
                return DeploymentState.unknown;
            }
        }
        return DeploymentState.unknown;
    }

    public Map<String, String> getAttributes() {
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        if (this.pod != null) {
            result.put("pod.name", this.pod.getMetadata().getName());
            result.put("pod.startTime", this.nullSafe(this.pod.getStatus().getStartTime()));
            result.put("pod.ip", this.nullSafe(this.pod.getStatus().getPodIP()));
            result.put("actuator.path", this.determineActuatorPathFromLivenessProbe(this.pod));
            result.put("actuator.port", this.determineActuatorPortFromLivenessProbe(this.pod, result.get("actuator.path")));
            result.put("host.ip", this.nullSafe(this.pod.getStatus().getHostIP()));
            result.put("phase", this.nullSafe(this.pod.getStatus().getPhase()));
            result.put("spring-app-id".replace('-', '.'), (String)this.pod.getMetadata().getLabels().get("spring-app-id"));
            result.put("spring-deployment-id".replace('-', '.'), (String)this.pod.getMetadata().getLabels().get("spring-deployment-id"));
            result.put("guid", this.pod.getMetadata().getUid());
        } else {
            logger.debug((Object)"getAttributes:no pod");
        }
        if (this.service != null) {
            result.put("service.name", this.service.getMetadata().getName());
            if ("LoadBalancer".equals(this.service.getSpec().getType()) && this.service.getStatus() != null && this.service.getStatus().getLoadBalancer() != null && this.service.getStatus().getLoadBalancer().getIngress() != null && !this.service.getStatus().getLoadBalancer().getIngress().isEmpty()) {
                String externalIp = ((LoadBalancerIngress)this.service.getStatus().getLoadBalancer().getIngress().get(0)).getIp();
                if (externalIp == null) {
                    externalIp = ((LoadBalancerIngress)this.service.getStatus().getLoadBalancer().getIngress().get(0)).getHostname();
                }
                result.put("service.external.ip", externalIp);
                List ports = this.service.getSpec().getPorts();
                int port = 0;
                if (ports != null && ports.size() > 0) {
                    port = ((ServicePort)ports.get(0)).getPort();
                    result.put("service.external.port", String.valueOf(port));
                }
                if (externalIp != null) {
                    result.put("url", "http://" + externalIp + (port > 0 && port != 80 ? ":" + port : ""));
                }
            }
        } else {
            logger.debug((Object)"getAttributes:no service");
        }
        if (this.containerStatus != null) {
            result.put("container.restartCount", "" + this.containerStatus.getRestartCount());
            if (this.containerStatus.getLastState() != null && this.containerStatus.getLastState().getTerminated() != null) {
                result.put("container.lastState.terminated.exitCode", "" + this.containerStatus.getLastState().getTerminated().getExitCode());
                result.put("container.lastState.terminated.reason", this.containerStatus.getLastState().getTerminated().getReason());
            }
            if (this.containerStatus.getState() != null && this.containerStatus.getState().getTerminated() != null) {
                result.put("container.state.terminated.exitCode", "" + this.containerStatus.getState().getTerminated().getExitCode());
                result.put("container.state.terminated.reason", this.containerStatus.getState().getTerminated().getReason());
            }
        } else {
            logger.debug((Object)"getAttributes:no containerStatus");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getAttributes:" + result));
        }
        return result;
    }

    private String nullSafe(String value) {
        return value == null ? "" : value;
    }

    private String determineActuatorPathFromLivenessProbe(Pod pod) {
        return pod.getSpec().getContainers().stream().filter(container -> container.getLivenessProbe() != null && container.getLivenessProbe().getHttpGet() != null).findFirst().map(container -> Paths.get(container.getLivenessProbe().getHttpGet().getPath(), new String[0]).getParent().toString()).orElse("/actuator");
    }

    private String determineActuatorPortFromLivenessProbe(Pod pod, String path) {
        IntOrString intOrString = pod.getSpec().getContainers().stream().filter(container -> container.getLivenessProbe() != null && container.getLivenessProbe().getHttpGet() != null && container.getLivenessProbe().getHttpGet().getPath().equals(path)).findFirst().map(container -> container.getLivenessProbe().getHttpGet().getPort()).orElse(new IntOrString(Integer.valueOf(8080)));
        return intOrString.getIntVal() != null ? String.valueOf(intOrString.getIntVal()) : intOrString.getStrVal();
    }
}

