/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.StatusCause;
import io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1beta1.CronJob;
import io.fabric8.kubernetes.api.model.batch.v1beta1.CronJobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1beta1.CronJobFluent;
import io.fabric8.kubernetes.api.model.batch.v1beta1.CronJobList;
import io.fabric8.kubernetes.api.model.batch.v1beta1.CronJobSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1beta1.JobTemplateSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.kubernetes.AbstractKubernetesDeployer;
import org.springframework.cloud.deployer.spi.kubernetes.DefaultContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.DeploymentPropertiesResolver;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesSchedulerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.RestartPolicy;
import org.springframework.cloud.deployer.spi.scheduler.CreateScheduleException;
import org.springframework.cloud.deployer.spi.scheduler.ScheduleInfo;
import org.springframework.cloud.deployer.spi.scheduler.ScheduleRequest;
import org.springframework.cloud.deployer.spi.scheduler.Scheduler;
import org.springframework.cloud.deployer.spi.scheduler.SchedulerException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class KubernetesScheduler
extends AbstractKubernetesDeployer
implements Scheduler {
    protected static final String SPRING_CRONJOB_ID_KEY = "spring-cronjob-id";
    private static final String SCHEDULE_EXPRESSION_FIELD_NAME = "spec.schedule";
    static final String KUBERNETES_DEPLOYER_CRON_CONCURRENCY_POLICY = "spring.cloud.deployer.kubernetes.cron.concurrencyPolicy";

    public KubernetesScheduler(KubernetesClient client, KubernetesDeployerProperties properties) {
        Assert.notNull((Object)client, (String)"KubernetesClient must not be null");
        Assert.notNull((Object)properties, (String)"KubernetesSchedulerProperties must not be null");
        this.client = client;
        this.properties = properties;
        this.containerFactory = new DefaultContainerFactory(properties);
        this.deploymentPropertiesResolver = new DeploymentPropertiesResolver(properties instanceof KubernetesSchedulerProperties ? "spring.cloud.scheduler.kubernetes" : "spring.cloud.deployer.kubernetes", properties);
    }

    public void schedule(ScheduleRequest scheduleRequest) {
        this.validateScheduleName(scheduleRequest);
        try {
            this.createCronJob(scheduleRequest);
        }
        catch (KubernetesClientException e) {
            String invalidCronExceptionMessage = this.getExceptionMessageForField(e, SCHEDULE_EXPRESSION_FIELD_NAME);
            if (StringUtils.hasText((String)invalidCronExceptionMessage)) {
                throw new CreateScheduleException(invalidCronExceptionMessage, (Throwable)e);
            }
            throw new CreateScheduleException("Failed to create schedule " + scheduleRequest.getScheduleName(), (Throwable)e);
        }
    }

    static Map<String, String> mergeSchedulerProperties(ScheduleRequest scheduleRequest) {
        HashMap<String, String> deploymentProperties = new HashMap<String, String>();
        Map schedulerProperties = scheduleRequest.getSchedulerProperties();
        if (scheduleRequest.getDeploymentProperties() != null) {
            deploymentProperties.putAll(scheduleRequest.getDeploymentProperties());
        }
        if (schedulerProperties != null) {
            for (Map.Entry schedulerProperty : schedulerProperties.entrySet()) {
                String schedulerPropertyKey = (String)schedulerProperty.getKey();
                if (StringUtils.hasText((String)schedulerPropertyKey) && schedulerPropertyKey.startsWith("spring.cloud.scheduler.kubernetes")) {
                    String deployerPropertyKey = "spring.cloud.deployer.kubernetes" + schedulerPropertyKey.substring("spring.cloud.scheduler.kubernetes".length());
                    deploymentProperties.put(deployerPropertyKey, (String)schedulerProperty.getValue());
                    continue;
                }
                if (!StringUtils.hasText((String)schedulerPropertyKey) || !schedulerPropertyKey.startsWith("spring.cloud.scheduler.") || deploymentProperties.containsKey(schedulerPropertyKey)) continue;
                deploymentProperties.put(schedulerPropertyKey, (String)schedulerProperty.getValue());
            }
        }
        if (!deploymentProperties.containsKey("spring.cloud.deployer.kubernetes.restartPolicy")) {
            deploymentProperties.put("spring.cloud.deployer.kubernetes.restartPolicy", RestartPolicy.Never.name());
        }
        if (deploymentProperties.containsKey("spring.cloud.deployer.cron.expression")) {
            deploymentProperties.put("spring.cloud.deployer.kubernetes.cron.expression", (String)deploymentProperties.get("spring.cloud.deployer.cron.expression"));
        }
        HashMap updatedDeploymentProperties = new HashMap();
        HashMap updatedSchedulerProperties = new HashMap();
        for (Map.Entry schedulerProperty : deploymentProperties.entrySet()) {
            String schedulerPropertyKey = (String)schedulerProperty.getKey();
            if (StringUtils.hasText((String)schedulerPropertyKey) && schedulerPropertyKey.startsWith("spring.cloud.scheduler.kubernetes")) {
                String deployerPropertyKey = "spring.cloud.deployer.kubernetes" + schedulerPropertyKey.substring("spring.cloud.scheduler.kubernetes".length());
                updatedSchedulerProperties.put(deployerPropertyKey, schedulerProperty.getValue());
                continue;
            }
            updatedDeploymentProperties.put(schedulerProperty.getKey(), schedulerProperty.getValue());
        }
        deploymentProperties.clear();
        deploymentProperties.putAll(updatedDeploymentProperties);
        deploymentProperties.putAll(updatedSchedulerProperties);
        return deploymentProperties;
    }

    public void validateScheduleName(ScheduleRequest request) {
        if (request.getScheduleName() == null) {
            throw new CreateScheduleException("The name for the schedule request is null", null);
        }
        if (request.getScheduleName().length() > 52) {
            throw new CreateScheduleException(String.format("because Schedule Name: '%s' has too many characters.  Schedule name length must be 52 characters or less", request.getScheduleName()), null);
        }
        if (!Pattern.matches("^[a-z0-9]([-a-z0-9]*[a-z0-9])?$", request.getScheduleName())) {
            throw new CreateScheduleException("Invalid Format for Schedule Name. Schedule name can only contain lowercase letters, numbers 0-9 and hyphens.", null);
        }
    }

    public void unschedule(String scheduleName) {
        boolean unscheduled = ((Resource)this.client.batch().cronjobs().withName(scheduleName)).delete();
        if (!unscheduled) {
            throw new SchedulerException("Failed to unschedule schedule " + scheduleName + " does not exist.");
        }
    }

    public List<ScheduleInfo> list(String taskDefinitionName) {
        return this.list().stream().filter(scheduleInfo -> taskDefinitionName.equals(scheduleInfo.getTaskDefinitionName())).collect(Collectors.toList());
    }

    public List<ScheduleInfo> list() {
        CronJobList cronJobList = (CronJobList)this.client.batch().cronjobs().list();
        List cronJobs = cronJobList.getItems();
        ArrayList<ScheduleInfo> scheduleInfos = new ArrayList<ScheduleInfo>();
        for (CronJob cronJob : cronJobs) {
            if (cronJob.getMetadata() == null || cronJob.getMetadata().getLabels() == null || !StringUtils.hasText((String)((String)cronJob.getMetadata().getLabels().get(SPRING_CRONJOB_ID_KEY)))) continue;
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("spring.cloud.scheduler.cron.expression", cronJob.getSpec().getSchedule());
            ScheduleInfo scheduleInfo = new ScheduleInfo();
            scheduleInfo.setScheduleName(cronJob.getMetadata().getName());
            scheduleInfo.setTaskDefinitionName((String)cronJob.getMetadata().getLabels().get(SPRING_CRONJOB_ID_KEY));
            scheduleInfo.setScheduleProperties(properties);
            scheduleInfos.add(scheduleInfo);
        }
        return scheduleInfos;
    }

    protected CronJob createCronJob(ScheduleRequest scheduleRequest) {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put(SPRING_CRONJOB_ID_KEY, scheduleRequest.getDefinition().getName());
        Map<String, String> schedulerProperties = KubernetesScheduler.mergeSchedulerProperties(scheduleRequest);
        String schedule = schedulerProperties.get("spring.cloud.deployer.kubernetes.cron.expression") != null ? schedulerProperties.get("spring.cloud.deployer.kubernetes.cron.expression") : schedulerProperties.get("spring.cloud.scheduler.cron.expression");
        Assert.hasText((String)schedule, (String)"The property spring.cloud.deployer.cron.expression must be defined");
        String concurrencyPolicy = schedulerProperties.get(KUBERNETES_DEPLOYER_CRON_CONCURRENCY_POLICY);
        if (!StringUtils.hasText((String)concurrencyPolicy)) {
            concurrencyPolicy = this.properties.getCron().getConcurrencyPolicy();
        }
        if (concurrencyPolicy == null) {
            concurrencyPolicy = "Allow";
        }
        PodSpec podSpec = this.createPodSpec((AppDeploymentRequest)new ScheduleRequest(scheduleRequest.getDefinition(), schedulerProperties, scheduleRequest.getCommandlineArguments(), scheduleRequest.getScheduleName(), scheduleRequest.getResource()));
        String taskServiceAccountName = this.deploymentPropertiesResolver.getTaskServiceAccountName(schedulerProperties);
        String string = taskServiceAccountName = taskServiceAccountName != null ? taskServiceAccountName : "default";
        if (StringUtils.hasText((String)taskServiceAccountName)) {
            podSpec.setServiceAccountName(taskServiceAccountName);
        }
        Map<String, String> annotations = this.deploymentPropertiesResolver.getPodAnnotations(schedulerProperties);
        labels.putAll(this.deploymentPropertiesResolver.getDeploymentLabels(schedulerProperties));
        CronJob cronJob = ((CronJobBuilder)((CronJobFluent.SpecNested)((CronJobSpecFluent.JobTemplateNested)((JobTemplateSpecFluent.SpecNested)((JobSpecFluent.TemplateNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((CronJobFluent.SpecNested)((CronJobFluent.SpecNested)((CronJobBuilder)((CronJobFluent.MetadataNested)((CronJobFluent.MetadataNested)((CronJobFluent.MetadataNested)new CronJobBuilder().withNewMetadata().withName(scheduleRequest.getScheduleName())).withLabels(labels)).withAnnotations(this.deploymentPropertiesResolver.getJobAnnotations(schedulerProperties))).endMetadata()).withNewSpec().withSchedule(schedule)).withConcurrencyPolicy(concurrencyPolicy)).withNewJobTemplate().withNewSpec().withNewTemplate().withNewMetadata().addToAnnotations(annotations)).addToLabels(labels)).endMetadata()).withSpec(podSpec)).endTemplate()).endSpec()).endJobTemplate()).endSpec()).build();
        this.setImagePullSecret(scheduleRequest, cronJob);
        return (CronJob)this.client.batch().cronjobs().create((Object)cronJob);
    }

    protected String getExceptionMessageForField(KubernetesClientException clientException, String fieldName) {
        if (clientException.getStatus() == null || clientException.getStatus().getDetails() == null) {
            return null;
        }
        List statusCauses = clientException.getStatus().getDetails().getCauses();
        if (!CollectionUtils.isEmpty((Collection)statusCauses)) {
            for (StatusCause statusCause : statusCauses) {
                if (!fieldName.equals(statusCause.getField())) continue;
                return clientException.getStatus().getMessage();
            }
        }
        return null;
    }

    private void setImagePullSecret(ScheduleRequest scheduleRequest, CronJob cronJob) {
        String imagePullSecret = this.deploymentPropertiesResolver.getImagePullSecret(scheduleRequest.getDeploymentProperties());
        if (StringUtils.hasText((String)imagePullSecret)) {
            LocalObjectReference localObjectReference = new LocalObjectReference();
            localObjectReference.setName(imagePullSecret);
            cronJob.getSpec().getJobTemplate().getSpec().getTemplate().getSpec().getImagePullSecrets().add(localObjectReference);
        }
    }
}

