/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.HTTPGetActionBuilder;
import io.fabric8.kubernetes.api.model.HTTPHeader;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.ProbeAuthenticationType;
import org.springframework.cloud.deployer.spi.kubernetes.support.PropertyParserUtils;
import org.springframework.cloud.deployer.spi.scheduler.ScheduleRequest;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class ProbeCreator {
    protected static final String KUBERNETES_DEPLOYER_PREFIX = "spring.cloud.deployer.kubernetes";
    protected static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    protected static final String PROBE_CREDENTIALS_SECRET_KEY_NAME = "credentials";
    protected static final String BOOT_1_READINESS_PROBE_PATH = "/info";
    protected static final String BOOT_2_READINESS_PROBE_PATH = "/actuator/info";
    protected static final String BOOT_1_LIVENESS_PROBE_PATH = "/health";
    protected static final String BOOT_2_LIVENESS_PROBE_PATH = "/actuator/health";
    private static final int BOOT_1_MAJOR_VERSION = 1;
    private ContainerConfiguration containerConfiguration;
    private KubernetesDeployerProperties kubernetesDeployerProperties;

    ProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
        this.kubernetesDeployerProperties = kubernetesDeployerProperties;
    }

    Probe create() {
        HTTPGetActionBuilder httpGetActionBuilder = (HTTPGetActionBuilder)((HTTPGetActionBuilder)new HTTPGetActionBuilder().withPath(this.getProbePath())).withNewPort(this.getPort());
        List<HTTPHeader> httpHeaders = this.getHttpHeaders();
        if (!httpHeaders.isEmpty()) {
            httpGetActionBuilder.withHttpHeaders(httpHeaders);
        }
        return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)new ProbeBuilder().withHttpGet(httpGetActionBuilder.build())).withTimeoutSeconds(Integer.valueOf(this.getTimeout()))).withInitialDelaySeconds(Integer.valueOf(this.getInitialDelay()))).withPeriodSeconds(Integer.valueOf(this.getPeriod()))).build();
    }

    protected abstract String getProbePath();

    protected abstract Integer getPort();

    protected abstract int getTimeout();

    protected abstract int getInitialDelay();

    protected abstract int getPeriod();

    protected KubernetesDeployerProperties getKubernetesDeployerProperties() {
        return this.kubernetesDeployerProperties;
    }

    protected Map<String, String> getDeploymentProperties() {
        AppDeploymentRequest appDeploymentRequest = this.containerConfiguration.getAppDeploymentRequest();
        return appDeploymentRequest instanceof ScheduleRequest ? ((ScheduleRequest)appDeploymentRequest).getSchedulerProperties() : appDeploymentRequest.getDeploymentProperties();
    }

    protected String getDeploymentPropertyValue(String propertyName) {
        return PropertyParserUtils.getDeploymentPropertyValue(this.getDeploymentProperties(), propertyName);
    }

    protected Integer getDefaultPort() {
        return this.containerConfiguration.getExternalPort();
    }

    protected boolean useBoot1ProbePath() {
        Integer bootMajorVersion;
        String bootMajorVersionProperty = "spring.cloud.deployer.kubernetes.bootMajorVersion";
        String bootMajorVersionValue = this.getDeploymentPropertyValue(bootMajorVersionProperty);
        return StringUtils.hasText((String)bootMajorVersionValue) && (bootMajorVersion = Integer.valueOf(bootMajorVersionValue)) == 1;
    }

    private List<HTTPHeader> getHttpHeaders() {
        ArrayList<HTTPHeader> httpHeaders = new ArrayList<HTTPHeader>();
        HTTPHeader authenticationHeader = this.getAuthorizationHeader();
        if (authenticationHeader != null) {
            httpHeaders.add(authenticationHeader);
        }
        return httpHeaders;
    }

    private HTTPHeader getAuthorizationHeader() {
        HTTPHeader httpHeader = null;
        Secret probeCredentialsSecret = this.containerConfiguration.getProbeCredentialsSecret();
        if (probeCredentialsSecret != null) {
            Assert.isTrue((boolean)probeCredentialsSecret.getData().containsKey(PROBE_CREDENTIALS_SECRET_KEY_NAME), (String)"Secret does not contain a key by the name of credentials");
            httpHeader = new HTTPHeader();
            httpHeader.setName(AUTHORIZATION_HEADER_NAME);
            httpHeader.setValue(ProbeAuthenticationType.Basic.name() + " " + (String)probeCredentialsSecret.getData().get(PROBE_CREDENTIALS_SECRET_KEY_NAME));
        }
        return httpHeader;
    }
}

