/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.ProbeCreator;
import org.springframework.util.StringUtils;

class ReadinessProbeCreator
extends ProbeCreator {
    private static final String PROBE_PROPERTY_PREFIX = "spring.cloud.deployer.kubernetes.readiness";

    public ReadinessProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    @Override
    public Integer getPort() {
        String probePortKey = "spring.cloud.deployer.kubernetes.readinessProbePort";
        String probePortValue = this.getDeploymentPropertyValue(probePortKey);
        if (StringUtils.hasText((String)probePortValue)) {
            return Integer.parseInt(probePortValue);
        }
        if (this.getKubernetesDeployerProperties().getReadinessProbePort() != null) {
            return this.getKubernetesDeployerProperties().getReadinessProbePort();
        }
        if (this.getDefaultPort() != null) {
            return this.getDefaultPort();
        }
        return null;
    }

    @Override
    protected String getProbePath() {
        String probePathKey = "spring.cloud.deployer.kubernetes.readinessProbePath";
        String probePathValue = this.getDeploymentPropertyValue(probePathKey);
        if (StringUtils.hasText((String)probePathValue)) {
            return probePathValue;
        }
        if (this.getKubernetesDeployerProperties().getReadinessProbePath() != null) {
            return this.getKubernetesDeployerProperties().getReadinessProbePath();
        }
        if (this.useBoot1ProbePath()) {
            return "/info";
        }
        return "/actuator/info";
    }

    @Override
    protected int getTimeout() {
        String probeTimeoutKey = "spring.cloud.deployer.kubernetes.readinessProbeTimeout";
        String probeTimeoutValue = this.getDeploymentPropertyValue(probeTimeoutKey);
        if (StringUtils.hasText((String)probeTimeoutValue)) {
            return Integer.valueOf(probeTimeoutValue);
        }
        return this.getKubernetesDeployerProperties().getReadinessProbeTimeout();
    }

    @Override
    protected int getInitialDelay() {
        String probeDelayKey = "spring.cloud.deployer.kubernetes.readinessProbeDelay";
        String probeDelayValue = this.getDeploymentPropertyValue(probeDelayKey);
        if (StringUtils.hasText((String)probeDelayValue)) {
            return Integer.valueOf(probeDelayValue);
        }
        return this.getKubernetesDeployerProperties().getReadinessProbeDelay();
    }

    @Override
    protected int getPeriod() {
        String probePeriodKey = "spring.cloud.deployer.kubernetes.readinessProbePeriod";
        String probePeriodValue = this.getDeploymentPropertyValue(probePeriodKey);
        if (StringUtils.hasText((String)probePeriodValue)) {
            return Integer.valueOf(probePeriodValue);
        }
        return this.getKubernetesDeployerProperties().getReadinessProbePeriod();
    }
}

