/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.RunningPhaseDeploymentStateResolver;

public class PredicateRunningPhaseDeploymentStateResolver
implements RunningPhaseDeploymentStateResolver {
    private static Log logger = LogFactory.getLog(PredicateRunningPhaseDeploymentStateResolver.class);
    private final ContainerStatusCondition[] conditions;
    private final DeploymentState resolvedState;
    protected final KubernetesDeployerProperties properties;

    PredicateRunningPhaseDeploymentStateResolver(KubernetesDeployerProperties properties, DeploymentState resolvedState, ContainerStatusCondition ... conditions) {
        this.conditions = conditions;
        this.resolvedState = resolvedState;
        this.properties = properties;
    }

    @Override
    public DeploymentState resolve(ContainerStatus containerStatus) {
        Stream<ContainerStatusCondition> conditionsStream = Stream.of(this.conditions);
        Boolean allConditionsMet = ((Predicate)conditionsStream.reduce((x, y) -> x.and(y)).get()).test(containerStatus);
        if (allConditionsMet.booleanValue()) {
            logger.debug((Object)("deployment state is " + this.resolvedState.name()));
            return this.resolvedState;
        }
        Stream<ContainerStatusCondition> report = Stream.of(this.conditions);
        report.filter(c -> {
            boolean result = false;
            try {
                result = c.test(containerStatus);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return !result;
        }).forEach(c -> logger.debug((Object)(c + " is not satisfied")));
        return null;
    }

    static class ContainerTerminated
    extends PredicateRunningPhaseDeploymentStateResolver {
        ContainerTerminated(KubernetesDeployerProperties properties) {
            super(properties, DeploymentState.undeployed, new ContainerStatusCondition("restart count == 0"){

                @Override
                public boolean test(ContainerStatus containerStatus) {
                    return containerStatus.getRestartCount() == 0;
                }
            }, new ContainerStatusCondition("state is terminated"){

                @Override
                public boolean test(ContainerStatus containerStatus) {
                    return containerStatus.getState() != null && containerStatus.getState().getTerminated() != null;
                }
            });
        }
    }

    static class CrashLoopBackOffRestarts
    extends PredicateRunningPhaseDeploymentStateResolver {
        CrashLoopBackOffRestarts(final KubernetesDeployerProperties properties) {
            super(properties, DeploymentState.failed, new ContainerStatusCondition("restart count > CrashLoopBackOffRestarts"){

                @Override
                public boolean test(ContainerStatus containerStatus) {
                    return containerStatus.getRestartCount() > properties.getMaxCrashLoopBackOffRestarts();
                }
            }, new ContainerStatusCondition("waiting in CrashLoopBackOff"){

                @Override
                public boolean test(ContainerStatus containerStatus) {
                    return containerStatus.getLastState() != null && containerStatus.getState() != null && containerStatus.getLastState().getTerminated() != null && containerStatus.getState().getWaiting() != null && containerStatus.getState().getWaiting().getReason() != null && containerStatus.getState().getWaiting().getReason().contains("CrashLoopBackOff");
                }
            });
        }
    }

    static class RestartsDueToTheSameError
    extends PredicateRunningPhaseDeploymentStateResolver {
        RestartsDueToTheSameError(final KubernetesDeployerProperties properties) {
            super(properties, DeploymentState.failed, new ContainerStatusCondition("restart count > maxTerminatedErrorRestarts"){

                @Override
                public boolean test(ContainerStatus containerStatus) {
                    return containerStatus.getRestartCount() > properties.getMaxTerminatedErrorRestarts();
                }
            }, new ContainerStatusCondition("last state termination reason == 'Error' and termination reason == 'Error'"){

                @Override
                public boolean test(ContainerStatus containerStatus) {
                    return containerStatus.getLastState() != null && containerStatus.getState() != null && containerStatus.getLastState().getTerminated() != null && containerStatus.getLastState().getTerminated().getReason() != null && containerStatus.getLastState().getTerminated().getReason().contains("Error") && containerStatus.getState().getTerminated() != null && containerStatus.getState().getTerminated().getReason() != null && containerStatus.getState().getTerminated().getReason().contains("Error");
                }
            }, new ContainerStatusCondition("last state exit code == exit code"){

                @Override
                public boolean test(ContainerStatus containerStatus) {
                    return containerStatus.getLastState().getTerminated().getExitCode().equals(containerStatus.getState().getTerminated().getExitCode());
                }
            });
        }
    }

    static class ContainerCrashed
    extends PredicateRunningPhaseDeploymentStateResolver {
        ContainerCrashed(final KubernetesDeployerProperties properties) {
            super(properties, DeploymentState.failed, new ContainerStatusCondition("restart count > maxTerminatedErrorRestarts"){

                @Override
                public boolean test(ContainerStatus containerStatus) {
                    return containerStatus.getRestartCount() > properties.getMaxTerminatedErrorRestarts();
                }
            }, new ContainerStatusCondition("exit code in (1, 137, 143)"){

                @Override
                public boolean test(ContainerStatus containerStatus) {
                    return containerStatus.getLastState() != null && containerStatus.getLastState().getTerminated() != null && (containerStatus.getLastState().getTerminated().getExitCode() == 137 || containerStatus.getLastState().getTerminated().getExitCode() == 143 || containerStatus.getLastState().getTerminated().getExitCode() == 1);
                }
            });
        }
    }

    static class ContainerReady
    extends PredicateRunningPhaseDeploymentStateResolver {
        ContainerReady(KubernetesDeployerProperties properties) {
            super(properties, DeploymentState.deployed, new ContainerStatusCondition("container ready"){

                @Override
                public boolean test(ContainerStatus containerStatus) {
                    return containerStatus.getReady();
                }
            });
        }
    }

    static abstract class ContainerStatusCondition
    implements Predicate<ContainerStatus> {
        private final String description;

        ContainerStatusCondition(String description) {
            this.description = description;
        }

        public String toString() {
            String className = this.getClass().getName();
            return className.substring(className.lastIndexOf(".") + 1) + ":" + this.description;
        }
    }
}

