/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.deployer.spi.kubernetes.EntryPointStyle;
import org.springframework.cloud.deployer.spi.kubernetes.ImagePullPolicy;

@ConfigurationProperties(prefix="spring.cloud.deployer.kubernetes")
public class KubernetesDeployerProperties {
    public static final String KUBERNETES_DEPLOYMENT_NODE_SELECTOR = "spring.cloud.deployer.kubernetes.deployment.nodeSelector";
    private static String KUBERNETES_NAMESPACE = System.getenv("KUBERNETES_NAMESPACE") != null ? System.getenv("KUBERNETES_NAMESPACE") : "default";
    private String namespace = KUBERNETES_NAMESPACE;
    private String imagePullSecret;
    private int livenessProbeDelay = 10;
    private int livenessProbePeriod = 60;
    private int livenessProbeTimeout = 2;
    private String livenessProbePath = "/health";
    private int readinessProbeDelay = 10;
    private int readinessProbePeriod = 10;
    private int readinessProbeTimeout = 2;
    private String readinessProbePath = "/info";
    @Deprecated
    private String memory = "1024Mi";
    @Deprecated
    private String cpu = "500m";
    private Resources limits = new Resources();
    private Resources requests = new Resources();
    private String[] environmentVariables = new String[0];
    private EntryPointStyle entryPointStyle = EntryPointStyle.exec;
    private boolean createLoadBalancer = false;
    private String serviceAnnotations = null;
    private int minutesToWaitForLoadBalancer = 5;
    private int maxTerminatedErrorRestarts = 2;
    private int maxCrashLoopBackOffRestarts = 4;
    private ImagePullPolicy imagePullPolicy = ImagePullPolicy.IfNotPresent;
    private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
    private List<Volume> volumes = new ArrayList<Volume>();
    private boolean hostNetwork = false;
    private boolean createDeployment = true;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getImagePullSecret() {
        return this.imagePullSecret;
    }

    public void setImagePullSecret(String imagePullSecret) {
        this.imagePullSecret = imagePullSecret;
    }

    public int getLivenessProbeDelay() {
        return this.livenessProbeDelay;
    }

    public void setLivenessProbeDelay(int livenessProbeDelay) {
        this.livenessProbeDelay = livenessProbeDelay;
    }

    public int getLivenessProbePeriod() {
        return this.livenessProbePeriod;
    }

    public void setLivenessProbePeriod(int livenessProbePeriod) {
        this.livenessProbePeriod = livenessProbePeriod;
    }

    public int getLivenessProbeTimeout() {
        return this.livenessProbeTimeout;
    }

    public void setLivenessProbeTimeout(int livenessProbeTimeout) {
        this.livenessProbeTimeout = livenessProbeTimeout;
    }

    public String getLivenessProbePath() {
        return this.livenessProbePath;
    }

    public void setLivenessProbePath(String livenessProbePath) {
        this.livenessProbePath = livenessProbePath;
    }

    public int getReadinessProbeDelay() {
        return this.readinessProbeDelay;
    }

    public void setReadinessProbeDelay(int readinessProbeDelay) {
        this.readinessProbeDelay = readinessProbeDelay;
    }

    public int getReadinessProbePeriod() {
        return this.readinessProbePeriod;
    }

    public void setReadinessProbePeriod(int readinessProbePeriod) {
        this.readinessProbePeriod = readinessProbePeriod;
    }

    public int getReadinessProbeTimeout() {
        return this.readinessProbeTimeout;
    }

    public void setReadinessProbeTimeout(int readinessProbeTimeout) {
        this.readinessProbeTimeout = readinessProbeTimeout;
    }

    public String getReadinessProbePath() {
        return this.readinessProbePath;
    }

    public void setReadinessProbePath(String readinessProbePath) {
        this.readinessProbePath = readinessProbePath;
    }

    @Deprecated
    public String getMemory() {
        return this.memory;
    }

    @Deprecated
    public void setMemory(String memory) {
        this.memory = memory;
    }

    @Deprecated
    public String getCpu() {
        return this.cpu;
    }

    @Deprecated
    public void setCpu(String cpu) {
        this.cpu = cpu;
    }

    public String[] getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(String[] environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public EntryPointStyle getEntryPointStyle() {
        return this.entryPointStyle;
    }

    public void setEntryPointStyle(EntryPointStyle entryPointStyle) {
        this.entryPointStyle = entryPointStyle;
    }

    public boolean isCreateLoadBalancer() {
        return this.createLoadBalancer;
    }

    public void setCreateLoadBalancer(boolean createLoadBalancer) {
        this.createLoadBalancer = createLoadBalancer;
    }

    public String getServiceAnnotations() {
        return this.serviceAnnotations;
    }

    public void setServiceAnnotations(String serviceAnnotations) {
        this.serviceAnnotations = serviceAnnotations;
    }

    public int getMinutesToWaitForLoadBalancer() {
        return this.minutesToWaitForLoadBalancer;
    }

    public void setMinutesToWaitForLoadBalancer(int minutesToWaitForLoadBalancer) {
        this.minutesToWaitForLoadBalancer = minutesToWaitForLoadBalancer;
    }

    public int getMaxTerminatedErrorRestarts() {
        return this.maxTerminatedErrorRestarts;
    }

    public void setMaxTerminatedErrorRestarts(int maxTerminatedErrorRestarts) {
        this.maxTerminatedErrorRestarts = maxTerminatedErrorRestarts;
    }

    public int getMaxCrashLoopBackOffRestarts() {
        return this.maxCrashLoopBackOffRestarts;
    }

    public void setMaxCrashLoopBackOffRestarts(int maxCrashLoopBackOffRestarts) {
        this.maxCrashLoopBackOffRestarts = maxCrashLoopBackOffRestarts;
    }

    public ImagePullPolicy getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public void setImagePullPolicy(ImagePullPolicy imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public Resources getLimits() {
        return this.limits;
    }

    public void setLimits(Resources limits) {
        this.limits = limits;
    }

    public Resources getRequests() {
        return this.requests;
    }

    public void setRequests(Resources requests) {
        this.requests = requests;
    }

    public List<VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    public void setVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    public List<Volume> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(List<Volume> volumes) {
        this.volumes = volumes;
    }

    public boolean isHostNetwork() {
        return this.hostNetwork;
    }

    public void setHostNetwork(boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
    }

    @Deprecated
    public boolean isCreateDeployment() {
        return this.createDeployment;
    }

    @Deprecated
    public void setCreateDeployment(boolean createDeployment) {
        this.createDeployment = createDeployment;
    }

    public static class Resources {
        private String cpu;
        private String memory;

        public Resources() {
        }

        public Resources(String cpu, String memory) {
            this.cpu = cpu;
            this.memory = memory;
        }

        public String getCpu() {
            return this.cpu;
        }

        public void setCpu(String cpu) {
            this.cpu = cpu;
        }

        public String getMemory() {
            return this.memory;
        }

        public void setMemory(String memory) {
            this.memory = memory;
        }
    }
}

