/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.DoneableService;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.kubernetes.AbstractKubernetesDeployer;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.DefaultContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KubernetesAppDeployer
extends AbstractKubernetesDeployer
implements AppDeployer {
    private static final String SERVER_PORT_KEY = "server.port";

    @Autowired
    public KubernetesAppDeployer(KubernetesDeployerProperties properties, KubernetesClient client) {
        this(properties, client, new DefaultContainerFactory(properties));
    }

    @Autowired
    public KubernetesAppDeployer(KubernetesDeployerProperties properties, KubernetesClient client, ContainerFactory containerFactory) {
        this.properties = properties;
        this.client = client;
        this.containerFactory = containerFactory;
    }

    public String deploy(AppDeploymentRequest request) {
        String appId = this.createDeploymentId(request);
        logger.debug((Object)String.format("Deploying app: %s", appId));
        try {
            boolean indexed;
            AppStatus status = this.status(appId);
            if (!status.getState().equals((Object)DeploymentState.unknown)) {
                throw new IllegalStateException(String.format("App '%s' is already deployed", appId));
            }
            int externalPort = this.configureExternalPort(request);
            String countProperty = (String)request.getDeploymentProperties().get("spring.cloud.deployer.count");
            int count = countProperty != null ? Integer.parseInt(countProperty) : 1;
            String indexedProperty = (String)request.getDeploymentProperties().get("spring.cloud.deployer.indexed");
            boolean bl = indexed = indexedProperty != null ? Boolean.valueOf(indexedProperty) : false;
            if (indexed) {
                for (int index = 0; index < count; ++index) {
                    String indexedId = appId + "-" + index;
                    Map<String, String> idMap = this.createIdMap(appId, request, index);
                    logger.debug((Object)String.format("Creating Service: %s on %d with index %d", appId, externalPort, index));
                    this.createService(indexedId, request, idMap, externalPort);
                    if (this.properties.isCreateDeployment()) {
                        logger.debug((Object)String.format("Creating Deployment: %s with index %d", appId, index));
                        this.createDeployment(indexedId, request, idMap, externalPort, 1, index);
                        continue;
                    }
                    logger.debug((Object)String.format("Creating Replication Controller: %s with index %d", appId, index));
                    this.createReplicationController(indexedId, request, idMap, externalPort, 1, index);
                }
            } else {
                Map<String, String> idMap = this.createIdMap(appId, request, null);
                logger.debug((Object)String.format("Creating Service: %s on {}", appId, externalPort));
                this.createService(appId, request, idMap, externalPort);
                if (this.properties.isCreateDeployment()) {
                    logger.debug((Object)String.format("Creating Deployment: %s", appId));
                    this.createDeployment(appId, request, idMap, externalPort, count, null);
                } else {
                    logger.debug((Object)String.format("Creating Replication Controller: %s", appId));
                    this.createReplicationController(appId, request, idMap, externalPort, count, null);
                }
            }
            return appId;
        }
        catch (RuntimeException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void undeploy(String appId) {
        logger.debug((Object)String.format("Undeploying app: %s", appId));
        AppStatus status = this.status(appId);
        if (status.getState().equals((Object)DeploymentState.unknown)) {
            throw new IllegalStateException(String.format("App '%s' is not deployed", appId));
        }
        List apps = ((ServiceList)((FilterWatchListDeletable)this.client.services().withLabel("spring-app-id", appId)).list()).getItems();
        if (apps != null) {
            for (Service app : apps) {
                String appIdToDelete = app.getMetadata().getName();
                logger.debug((Object)String.format("Deleting Resources for: %s", appIdToDelete));
                Service svc = (Service)((Resource)this.client.services().withName(appIdToDelete)).get();
                try {
                    Boolean deplDeleted;
                    if (svc != null && "LoadBalancer".equals(svc.getSpec().getType())) {
                        int tries = 0;
                        int maxWait = this.properties.getMinutesToWaitForLoadBalancer() * 6;
                        while (tries++ < maxWait && svc.getStatus() != null && svc.getStatus().getLoadBalancer() != null && svc.getStatus().getLoadBalancer().getIngress() != null && svc.getStatus().getLoadBalancer().getIngress().isEmpty()) {
                            if (tries % 6 == 0) {
                                logger.warn((Object)"Waiting for LoadBalancer to complete before deleting it ...");
                            }
                            logger.debug((Object)String.format("Waiting for LoadBalancer, try %d", tries));
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            svc = (Service)((Resource)this.client.services().withName(appIdToDelete)).get();
                        }
                        logger.debug((Object)String.format("LoadBalancer Ingress: %s", svc.getStatus().getLoadBalancer().getIngress().toString()));
                    }
                    Boolean svcDeleted = (Boolean)((Resource)this.client.services().withName(appIdToDelete)).delete();
                    logger.debug((Object)String.format("Deleted Service for: %s %b", appIdToDelete, svcDeleted));
                    Boolean rcDeleted = (Boolean)((RollableScalableResource)this.client.replicationControllers().withName(appIdToDelete)).delete();
                    if (rcDeleted.booleanValue()) {
                        logger.debug((Object)String.format("Deleted Replication Controller for: %s %b", appIdToDelete, rcDeleted));
                    }
                    if ((deplDeleted = (Boolean)((ScalableResource)this.client.extensions().deployments().withName(appIdToDelete)).delete()).booleanValue()) {
                        logger.debug((Object)String.format("Deleted Deployment for: %s %b", appIdToDelete, deplDeleted));
                    }
                    HashMap<String, String> selector = new HashMap<String, String>();
                    selector.put("spring-app-id", appIdToDelete);
                    FilterWatchListDeletable podsToDelete = (FilterWatchListDeletable)this.client.pods().withLabels(selector);
                    if (podsToDelete != null && ((PodList)podsToDelete.list()).getItems() != null) {
                        Boolean podDeleted = (Boolean)podsToDelete.delete();
                        logger.debug((Object)String.format("Deleted Pods for: %s %b", appIdToDelete, podDeleted));
                        continue;
                    }
                    logger.debug((Object)String.format("No Pods to delete for: %s", appIdToDelete));
                }
                catch (RuntimeException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
        }
    }

    public AppStatus status(String appId) {
        HashMap<String, String> selector = new HashMap<String, String>();
        ServiceList services = (ServiceList)((FilterWatchListDeletable)this.client.services().withLabel("spring-app-id", appId)).list();
        selector.put("spring-app-id", appId);
        PodList podList = (PodList)((FilterWatchListDeletable)this.client.pods().withLabels(selector)).list();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Building AppStatus for app: %s", appId));
            if (podList != null && podList.getItems() != null) {
                logger.debug((Object)String.format("Pods for appId %s: %d", appId, podList.getItems().size()));
                for (Pod pod : podList.getItems()) {
                    logger.debug((Object)String.format("Pod: %s", pod.getMetadata().getName()));
                }
            }
        }
        AppStatus status = this.buildAppStatus(appId, podList, services);
        logger.debug((Object)String.format("Status for app: %s is %s", appId, status));
        return status;
    }

    public RuntimeEnvironmentInfo environmentInfo() {
        return super.createRuntimeEnvironmentInfo(AppDeployer.class, this.getClass());
    }

    protected int configureExternalPort(AppDeploymentRequest request) {
        int externalPort = 8080;
        Map parameters = request.getDefinition().getProperties();
        if (parameters.containsKey(SERVER_PORT_KEY)) {
            externalPort = Integer.valueOf((String)parameters.get(SERVER_PORT_KEY));
        }
        return externalPort;
    }

    protected String createDeploymentId(AppDeploymentRequest request) {
        String groupId = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        String deploymentId = groupId == null ? String.format("%s", request.getDefinition().getName()) : String.format("%s-%s", groupId, request.getDefinition().getName());
        return deploymentId.replace('.', '-').toLowerCase();
    }

    private Deployment createDeployment(String appId, AppDeploymentRequest request, Map<String, String> idMap, int externalPort, int replicas, Integer instanceIndex) {
        Deployment d = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(appId)).withLabels(idMap)).addToLabels("role", "spring-app")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(replicas))).withNewTemplate().withNewMetadata().withLabels(idMap)).addToLabels("role", "spring-app")).endMetadata()).withSpec(this.createPodSpec(appId, request, externalPort, instanceIndex, false))).endTemplate()).endSpec()).build();
        return (Deployment)this.client.extensions().deployments().create((Object[])new Deployment[]{d});
    }

    private ReplicationController createReplicationController(String appId, AppDeploymentRequest request, Map<String, String> idMap, int externalPort, int replicas, Integer instanceIndex) {
        ReplicationController rc = ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName(appId)).withLabels(idMap)).addToLabels("role", "spring-app")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(replicas))).withSelector(idMap)).withNewTemplate().withNewMetadata().withLabels(idMap)).addToLabels("role", "spring-app")).endMetadata()).withSpec(this.createPodSpec(appId, request, externalPort, instanceIndex, false))).endTemplate()).endSpec()).build();
        return (ReplicationController)this.client.replicationControllers().create((Object[])new ReplicationController[]{rc});
    }

    protected void createService(String appId, AppDeploymentRequest request, Map<String, String> idMap, int externalPort) {
        ServiceSpecBuilder spec = new ServiceSpecBuilder();
        boolean isCreateLoadBalancer = false;
        String createLoadBalancer = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.createLoadBalancer");
        String createNodePort = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.createNodePort");
        if (createLoadBalancer != null && createNodePort != null) {
            throw new IllegalArgumentException("Cannot create NodePort and LoadBalancer at the same time.");
        }
        if (createLoadBalancer == null) {
            isCreateLoadBalancer = this.properties.isCreateLoadBalancer();
        } else if ("true".equals(createLoadBalancer.toLowerCase())) {
            isCreateLoadBalancer = true;
        }
        if (isCreateLoadBalancer) {
            spec.withType("LoadBalancer");
        }
        ServicePort servicePort = new ServicePort();
        servicePort.setPort(Integer.valueOf(externalPort));
        if (createNodePort != null) {
            spec.withType("NodePort");
            if (!"true".equals(createNodePort.toLowerCase())) {
                try {
                    Integer nodePort = Integer.valueOf(createNodePort);
                    servicePort.setNodePort(nodePort);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Invalid value: %s: provided port is not valid.", createNodePort));
                }
            }
        }
        ((ServiceSpecBuilder)spec.withSelector(idMap)).addNewPortLike(servicePort).endPort();
        Map<String, String> annotations = this.getServiceAnnotations(request.getDeploymentProperties());
        ((DoneableService)((DoneableService)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((DoneableService)((NonNamespaceOperation)this.client.services().inNamespace(this.client.getNamespace())).createNew()).withNewMetadata().withName(appId)).withLabels(idMap)).withAnnotations(annotations)).addToLabels("role", "spring-app")).endMetadata()).withSpec(spec.build())).done();
    }

    protected Map<String, String> getServiceAnnotations(Map<String, String> properties) {
        HashMap<String, String> annotations = new HashMap<String, String>();
        String annotationsProperty = properties.getOrDefault("spring.cloud.deployer.kubernetes.serviceAnnotations", "");
        if (StringUtils.isEmpty((Object)annotationsProperty)) {
            annotationsProperty = this.properties.getServiceAnnotations();
        }
        if (StringUtils.hasText((String)annotationsProperty)) {
            String[] annotationPairs;
            for (String annotationPair : annotationPairs = annotationsProperty.split(",")) {
                String[] annotation = annotationPair.split(":");
                Assert.isTrue((annotation.length == 2 ? 1 : 0) != 0, (String)String.format("Invalid annotation value: '{}'", annotationPair));
                annotations.put(annotation[0].trim(), annotation[1].trim());
            }
        }
        return annotations;
    }
}

