/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Quantity;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesAppInstanceStatus;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;

public class AbstractKubernetesDeployer {
    protected static final String SPRING_DEPLOYMENT_KEY = "spring-deployment-id";
    protected static final String SPRING_GROUP_KEY = "spring-group-id";
    protected static final String SPRING_APP_KEY = "spring-app-id";
    protected static final String SPRING_MARKER_KEY = "role";
    protected static final String SPRING_MARKER_VALUE = "spring-app";
    protected static final Log logger = LogFactory.getLog(AbstractKubernetesDeployer.class);

    protected Map<String, String> createIdMap(String appId, AppDeploymentRequest request, Integer instanceIndex) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(SPRING_APP_KEY, appId);
        String groupId = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        if (groupId != null) {
            map.put(SPRING_GROUP_KEY, groupId);
        }
        String appInstanceId = instanceIndex == null ? appId : appId + "-" + instanceIndex;
        map.put(SPRING_DEPLOYMENT_KEY, appInstanceId);
        return map;
    }

    protected AppStatus buildAppStatus(KubernetesDeployerProperties properties, String id, PodList list) {
        AppStatus.Builder statusBuilder = AppStatus.of((String)id);
        if (list == null) {
            statusBuilder.with((AppInstanceStatus)new KubernetesAppInstanceStatus(id, null, properties));
        } else {
            for (Pod pod : list.getItems()) {
                statusBuilder.with((AppInstanceStatus)new KubernetesAppInstanceStatus(id, pod, properties));
            }
        }
        return statusBuilder.build();
    }

    protected Map<String, Quantity> deduceResourceLimits(KubernetesDeployerProperties properties, AppDeploymentRequest request) {
        String cpuOverride;
        String memOverride = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.memory");
        if (memOverride == null) {
            memOverride = properties.getMemory();
        }
        if ((cpuOverride = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.cpu")) == null) {
            cpuOverride = properties.getCpu();
        }
        logger.debug((Object)("Using limits - cpu: " + cpuOverride + " mem: " + memOverride));
        HashMap<String, Quantity> limits = new HashMap<String, Quantity>();
        limits.put("memory", new Quantity(memOverride));
        limits.put("cpu", new Quantity(cpuOverride));
        return limits;
    }
}

