/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.loader.archive.JarFileArchive;
import org.springframework.core.io.Resource;

class CfEnvAwareResource
implements Resource {
    private final Resource resource;
    private final boolean hasCfEnv;

    static CfEnvAwareResource of(Resource resource) {
        return new CfEnvAwareResource(resource);
    }

    private CfEnvAwareResource(Resource resource) {
        this.resource = resource;
        this.hasCfEnv = CfEnvResolver.hasCfEnv(this);
    }

    public boolean exists() {
        return this.resource.exists();
    }

    public URL getURL() throws IOException {
        return this.resource.getURL();
    }

    public URI getURI() throws IOException {
        return this.resource.getURI();
    }

    public File getFile() throws IOException {
        return this.resource.getFile();
    }

    public long contentLength() throws IOException {
        return this.resource.contentLength();
    }

    public long lastModified() throws IOException {
        return this.resource.lastModified();
    }

    public Resource createRelative(String s) throws IOException {
        return this.resource.createRelative(s);
    }

    public String getFilename() {
        return this.resource.getFilename();
    }

    public String getDescription() {
        return this.resource.getDescription();
    }

    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }

    boolean hasCfEnv() {
        return this.hasCfEnv;
    }

    static class CfEnvResolver {
        private static Log logger = LogFactory.getLog(CfEnvResolver.class);
        private static final String CF_ENV = "io.pivotal.cfenv.core.CfEnv";

        CfEnvResolver() {
        }

        static boolean hasCfEnv(CfEnvAwareResource app) {
            try {
                String scheme = app.getURI().getScheme().toLowerCase();
                if (scheme.equals("docker")) {
                    return false;
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            try {
                JarFileArchive archive = new JarFileArchive(app.getFile());
                ArrayList urls = new ArrayList();
                archive.getNestedArchives(entry -> entry.getName().endsWith(".jar"), null).forEachRemaining(a -> {
                    try {
                        urls.add(a.getUrl());
                    }
                    catch (MalformedURLException e) {
                        logger.error((Object)("Unable to process nested archive " + e.getMessage()));
                    }
                });
                URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
                try {
                    logger.info((Object)"Attempting to load class CFEnv");
                    Class.forName(CF_ENV, false, classLoader);
                    return true;
                }
                catch (UnsupportedClassVersionError err) {
                    logger.debug((Object)(app.getFilename() + " contains " + CF_ENV));
                    return true;
                }
                catch (ClassNotFoundException e) {
                    logger.debug((Object)(app.getFilename() + " doesn't contain " + CF_ENV));
                    return false;
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to determine dependencies for file " + app.getFilename()));
                return false;
            }
        }
    }
}

