/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.deployer.spi.app.AppAdmin;
import org.springframework.validation.annotation.Validated;

@Validated
public class CloudFoundryDeploymentProperties {
    private static final Log log = LogFactory.getLog(CloudFoundryDeploymentProperties.class);
    public static final String SERVICES_PROPERTY_KEY = "spring.cloud.deployer.cloudfoundry.services";
    public static final String HEALTHCHECK_PROPERTY_KEY = "spring.cloud.deployer.cloudfoundry.health-check";
    public static final String HEALTHCHECK_HTTP_ENDPOINT_PROPERTY_KEY = "spring.cloud.deployer.cloudfoundry.health-check-http-endpoint";
    public static final String HEALTHCHECK_TIMEOUT_PROPERTY_KEY = "spring.cloud.deployer.cloudfoundry.health-check-timeout";
    public static final String ROUTE_PATH_PROPERTY = "spring.cloud.deployer.cloudfoundry.route-path";
    public static final String ROUTE_PROPERTY = "spring.cloud.deployer.cloudfoundry.route";
    public static final String ROUTES_PROPERTY = "spring.cloud.deployer.cloudfoundry.routes";
    public static final String NO_ROUTE_PROPERTY = "spring.cloud.deployer.cloudfoundry.no-route";
    public static final String HOST_PROPERTY = "spring.cloud.deployer.cloudfoundry.host";
    public static final String DOMAIN_PROPERTY = "spring.cloud.deployer.cloudfoundry.domain";
    public static final String BUILDPACK_PROPERTY_KEY = "spring.cloud.deployer.cloudfoundry.buildpack";
    public static final String BUILDPACKS_PROPERTY_KEY = "spring.cloud.deployer.cloudfoundry.buildpacks";
    public static final String JAVA_OPTS_PROPERTY_KEY = "spring.cloud.deployer.cloudfoundry.javaOpts";
    public static final String USE_SPRING_APPLICATION_JSON_KEY = "spring.cloud.deployer.cloudfoundry.use-spring-application-json";
    public static final String ENV_KEY = "spring.cloud.deployer.cloudfoundry.env";
    private static final String DEFAULT_BUILDPACK = "https://github.com/cloudfoundry/java-buildpack.git#v4.29.1";
    private Set<String> services = new HashSet<String>();
    private String host = null;
    private String domain;
    private Set<String> routes = new HashSet<String>();
    @Deprecated
    private String buildpack = "https://github.com/cloudfoundry/java-buildpack.git#v4.29.1";
    private Set<String> buildpacks = new HashSet<String>();
    private String memory = "1024m";
    private String disk = "1024m";
    private ApplicationHealthCheck healthCheck = ApplicationHealthCheck.PORT;
    private String healthCheckHttpEndpoint = "/health";
    private String healthCheckTimeout = "120";
    private int instances = 1;
    private boolean enableRandomAppNamePrefix = true;
    private long apiTimeout = 360L;
    private long statusTimeout = 30000L;
    private boolean useSpringApplicationJson = true;
    private Duration stagingTimeout = Duration.ofMinutes(15L);
    private Duration startupTimeout = Duration.ofMinutes(5L);
    @Value(value="${spring.application.name:}")
    private String appNamePrefix;
    private boolean deleteRoutes = true;
    private boolean pushTaskAppsEnabled = true;
    private boolean autoDeleteMavenArtifacts = true;
    @Min(value=1L)
    private @Min(value=1L) int maximumConcurrentTasks = 20;
    private String javaOpts;
    private Optional<Map<String, String>> env = Optional.empty();
    private String schedulerUrl;
    private int scheduleSSLRetryCount = 5;
    private int unScheduleTimeoutInSeconds = 30;
    private int scheduleTimeoutInSeconds = 30;
    private int listTimeoutInSeconds = 60;
    private AppAdmin appAdmin = new AppAdmin();

    public Set<String> getServices() {
        return this.services;
    }

    public void setServices(Set<String> services) {
        this.services = services;
    }

    @Deprecated
    public String getBuildpack() {
        return this.buildpack;
    }

    @Deprecated
    public void setBuildpack(String buildpack) {
        this.buildpack = buildpack;
    }

    public Set<String> getBuildpacks() {
        return this.buildpacks;
    }

    public void setBuildpacks(Set<String> buildpacks) {
        this.buildpacks = buildpacks;
    }

    public String getMemory() {
        return this.memory;
    }

    public void setMemory(String memory) {
        this.memory = memory;
    }

    public String getDisk() {
        return this.disk;
    }

    public void setDisk(String disk) {
        this.disk = disk;
    }

    public int getInstances() {
        return this.instances;
    }

    public void setInstances(int instances) {
        this.instances = instances;
    }

    public boolean isEnableRandomAppNamePrefix() {
        return this.enableRandomAppNamePrefix;
    }

    public void setEnableRandomAppNamePrefix(boolean enableRandomAppNamePrefix) {
        this.enableRandomAppNamePrefix = enableRandomAppNamePrefix;
    }

    public String getAppNamePrefix() {
        return this.appNamePrefix;
    }

    public void setAppNamePrefix(String appNamePrefix) {
        this.appNamePrefix = appNamePrefix;
    }

    public long getApiTimeout() {
        return this.apiTimeout;
    }

    public void setApiTimeout(long apiTimeout) {
        this.apiTimeout = apiTimeout;
    }

    public boolean isUseSpringApplicationJson() {
        return this.useSpringApplicationJson;
    }

    public void setUseSpringApplicationJson(boolean useSpringApplicationJson) {
        this.useSpringApplicationJson = useSpringApplicationJson;
    }

    public ApplicationHealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(ApplicationHealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    public String getHealthCheckHttpEndpoint() {
        return this.healthCheckHttpEndpoint;
    }

    public void setHealthCheckHttpEndpoint(String healthCheckHttpEndpoint) {
        this.healthCheckHttpEndpoint = healthCheckHttpEndpoint;
    }

    public String getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    public void setHealthCheckTimeout(String healthCheckTimeout) {
        this.healthCheckTimeout = healthCheckTimeout;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Set<String> getRoutes() {
        return this.routes;
    }

    public void setRoutes(Set<String> routes) {
        this.routes = routes;
    }

    public Duration getStagingTimeout() {
        return this.stagingTimeout;
    }

    public void setStagingTimeout(Duration stagingTimeout) {
        this.stagingTimeout = stagingTimeout;
    }

    public Duration getStartupTimeout() {
        return this.startupTimeout;
    }

    public void setStartupTimeout(Duration startupTimeout) {
        this.startupTimeout = startupTimeout;
    }

    public long getStatusTimeout() {
        return this.statusTimeout;
    }

    public void setStatusTimeout(long statusTimeout) {
        this.statusTimeout = statusTimeout;
    }

    public boolean isDeleteRoutes() {
        return this.deleteRoutes;
    }

    public void setDeleteRoutes(boolean deleteRoutes) {
        this.deleteRoutes = deleteRoutes;
    }

    public String getJavaOpts() {
        return this.javaOpts;
    }

    public void setJavaOpts(String javaOpts) {
        this.javaOpts = javaOpts;
    }

    public int getMaximumConcurrentTasks() {
        return this.maximumConcurrentTasks;
    }

    public void setMaximumConcurrentTasks(int maximumConcurrentTasks) {
        this.maximumConcurrentTasks = maximumConcurrentTasks;
    }

    public boolean isPushTaskAppsEnabled() {
        return this.pushTaskAppsEnabled;
    }

    public void setPushTaskAppsEnabled(boolean pushTaskAppsEnabled) {
        this.pushTaskAppsEnabled = pushTaskAppsEnabled;
    }

    public boolean isAutoDeleteMavenArtifacts() {
        return this.autoDeleteMavenArtifacts;
    }

    public void setAutoDeleteMavenArtifacts(boolean autoDeleteMavenArtifacts) {
        this.autoDeleteMavenArtifacts = autoDeleteMavenArtifacts;
    }

    public Map<String, String> getEnv() {
        return this.env.orElseGet(Collections::emptyMap);
    }

    public void setEnv(@NotNull Map<String, String> env) {
        this.env = Optional.of(Collections.unmodifiableMap(env));
        this.env.map(e -> {
            log.error((Object)"Environment is immutable. New entries have not been applied");
            return this.env;
        }).orElse(this.env);
    }

    public String getSchedulerUrl() {
        return this.schedulerUrl;
    }

    public void setSchedulerUrl(String schedulerUrl) {
        this.schedulerUrl = schedulerUrl;
    }

    public int getScheduleSSLRetryCount() {
        return this.scheduleSSLRetryCount;
    }

    public void setScheduleSSLRetryCount(int scheduleSSLRetryCount) {
        this.scheduleSSLRetryCount = scheduleSSLRetryCount;
    }

    public int getUnScheduleTimeoutInSeconds() {
        return this.unScheduleTimeoutInSeconds;
    }

    public void setUnScheduleTimeoutInSeconds(int unScheduleTimeoutInSeconds) {
        this.unScheduleTimeoutInSeconds = unScheduleTimeoutInSeconds;
    }

    public int getScheduleTimeoutInSeconds() {
        return this.scheduleTimeoutInSeconds;
    }

    public void setScheduleTimeoutInSeconds(int scheduleTimeoutInSeconds) {
        this.scheduleTimeoutInSeconds = scheduleTimeoutInSeconds;
    }

    public int getListTimeoutInSeconds() {
        return this.listTimeoutInSeconds;
    }

    public void setListTimeoutInSeconds(int listTimeoutInSeconds) {
        this.listTimeoutInSeconds = listTimeoutInSeconds;
    }

    public AppAdmin getAppAdmin() {
        return this.appAdmin;
    }

    public void setAppAdmin(AppAdmin appAdmin) {
        this.appAdmin = appAdmin;
    }
}

