/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.cloudfoundry.operations.applications.ApplicationDetail;
import org.cloudfoundry.operations.applications.InstanceDetail;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;

public class CloudFoundryAppInstanceStatus
implements AppInstanceStatus {
    private final InstanceDetail instanceDetail;
    private final ApplicationDetail applicationDetail;
    private final int index;
    private final Map<String, String> attributes = new TreeMap<String, String>();
    static final String GUID = "guid";
    static final String CF_GUID = "cf-guid";
    static final String INDEX = "index";

    public CloudFoundryAppInstanceStatus(ApplicationDetail applicationDetail, InstanceDetail instanceDetail, int index) {
        this.applicationDetail = applicationDetail;
        this.instanceDetail = instanceDetail;
        this.index = index;
    }

    public String getId() {
        return this.applicationDetail.getName() + "-" + this.index;
    }

    public DeploymentState getState() {
        if (this.instanceDetail == null) {
            return DeploymentState.failed;
        }
        switch (this.instanceDetail.getState()) {
            case "STARTING": 
            case "DOWN": {
                return DeploymentState.deploying;
            }
            case "CRASHED": {
                return DeploymentState.failed;
            }
            case "FLAPPING": 
            case "RUNNING": {
                return DeploymentState.deployed;
            }
            case "UNKNOWN": {
                return DeploymentState.unknown;
            }
        }
        throw new IllegalStateException("Unsupported CF state: " + this.instanceDetail.getState());
    }

    public Map<String, String> getAttributes() {
        List urls;
        if (this.instanceDetail != null) {
            if (this.instanceDetail.getCpu() != null) {
                this.attributes.put("metrics.machine.cpu", String.format("%.1f%%", this.instanceDetail.getCpu() * 100.0));
            }
            if (this.instanceDetail.getDiskQuota() != null && this.instanceDetail.getDiskUsage() != null) {
                this.attributes.put("metrics.machine.disk", String.format("%.1f%%", 100.0 * (double)this.instanceDetail.getDiskUsage().longValue() / (double)this.instanceDetail.getDiskQuota().longValue()));
            }
            if (this.instanceDetail.getMemoryQuota() != null && this.instanceDetail.getMemoryUsage() != null) {
                this.attributes.put("metrics.machine.memory", String.format("%.1f%%", 100.0 * (double)this.instanceDetail.getMemoryUsage().longValue() / (double)this.instanceDetail.getMemoryQuota().longValue()));
            }
        }
        if (!(urls = this.applicationDetail.getUrls()).isEmpty()) {
            this.attributes.put("url", "http://" + (String)urls.get(0));
            for (int i = 0; i < urls.size(); ++i) {
                this.attributes.put("url." + i, "http://" + (String)urls.get(i));
            }
        }
        this.attributes.put(GUID, this.applicationDetail.getName() + ":" + this.index);
        this.attributes.put(CF_GUID, this.applicationDetail.getId());
        this.attributes.put(INDEX, String.valueOf(this.index));
        return this.attributes;
    }

    public String toString() {
        return String.format("%s[%s : %s]", this.getClass().getSimpleName(), this.getId(), this.getState());
    }
}

