/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.springframework.beans.factory.annotation.Value;

public class CloudFoundryDeploymentProperties {
    public static final String SERVICES_PROPERTY_KEY = "spring.cloud.deployer.cloudfoundry.services";
    public static final String HEALTHCHECK_PROPERTY_KEY = "spring.cloud.deployer.cloudfoundry.health-check";
    public static final String ROUTE_PATH_PROPERTY = "spring.cloud.deployer.cloudfoundry.route-path";
    public static final String NO_ROUTE_PROPERTY = "spring.cloud.deployer.cloudfoundry.no-route";
    public static final String HOST_PROPERTY = "spring.cloud.deployer.cloudfoundry.host";
    public static final String DOMAIN_PROPERTY = "spring.cloud.deployer.cloudfoundry.domain";
    public static final String BUILDPACK_PROPERTY_KEY = "spring.cloud.deployer.cloudfoundry.buildpack";
    public static final String USE_SPRING_APPLICATION_JSON_KEY = "spring.cloud.deployer.cloudfoundry.use-spring-application-json";
    private Set<String> services = new HashSet<String>();
    private String host = null;
    private String domain;
    private String buildpack = "https://github.com/cloudfoundry/java-buildpack.git#v3.14";
    private String memory = "1024m";
    private String disk = "1024m";
    private ApplicationHealthCheck healthCheck = null;
    private int instances = 1;
    private boolean enableRandomAppNamePrefix = true;
    private long apiTimeout = 360L;
    private long statusTimeout = 5000L;
    private boolean useSpringApplicationJson = true;
    private Duration stagingTimeout = Duration.ofMinutes(15L);
    private Duration startupTimeout = Duration.ofMinutes(5L);
    @Value(value="${spring.application.name:}")
    private String appNamePrefix;

    public Set<String> getServices() {
        return this.services;
    }

    public void setServices(Set<String> services) {
        this.services = services;
    }

    public String getBuildpack() {
        return this.buildpack;
    }

    public void setBuildpack(String buildpack) {
        this.buildpack = buildpack;
    }

    public String getMemory() {
        return this.memory;
    }

    public void setMemory(String memory) {
        this.memory = memory;
    }

    public String getDisk() {
        return this.disk;
    }

    public void setDisk(String disk) {
        this.disk = disk;
    }

    public int getInstances() {
        return this.instances;
    }

    public void setInstances(int instances) {
        this.instances = instances;
    }

    public boolean isEnableRandomAppNamePrefix() {
        return this.enableRandomAppNamePrefix;
    }

    public void setEnableRandomAppNamePrefix(boolean enableRandomAppNamePrefix) {
        this.enableRandomAppNamePrefix = enableRandomAppNamePrefix;
    }

    public String getAppNamePrefix() {
        return this.appNamePrefix;
    }

    public void setAppNamePrefix(String appNamePrefix) {
        this.appNamePrefix = appNamePrefix;
    }

    public long getApiTimeout() {
        return this.apiTimeout;
    }

    public void setApiTimeout(long apiTimeout) {
        this.apiTimeout = apiTimeout;
    }

    public boolean isUseSpringApplicationJson() {
        return this.useSpringApplicationJson;
    }

    public void setUseSpringApplicationJson(boolean useSpringApplicationJson) {
        this.useSpringApplicationJson = useSpringApplicationJson;
    }

    public ApplicationHealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(ApplicationHealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Duration getStagingTimeout() {
        return this.stagingTimeout;
    }

    public void setStagingTimeout(Duration stagingTimeout) {
        this.stagingTimeout = stagingTimeout;
    }

    public Duration getStartupTimeout() {
        return this.startupTimeout;
    }

    public void setStartupTimeout(Duration startupTimeout) {
        this.startupTimeout = startupTimeout;
    }

    public long getStatusTimeout() {
        return this.statusTimeout;
    }

    public void setStatusTimeout(long statusTimeout) {
        this.statusTimeout = statusTimeout;
    }
}

