/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.organizations.ListOrganizationsRequest;
import org.cloudfoundry.client.v2.spaces.ListSpacesRequest;
import org.cloudfoundry.client.v3.BuildpackData;
import org.cloudfoundry.client.v3.Data;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.Type;
import org.cloudfoundry.client.v3.applications.Application;
import org.cloudfoundry.client.v3.applications.ApplicationResource;
import org.cloudfoundry.client.v3.applications.CreateApplicationRequest;
import org.cloudfoundry.client.v3.applications.ListApplicationDropletsRequest;
import org.cloudfoundry.client.v3.applications.ListApplicationDropletsResponse;
import org.cloudfoundry.client.v3.applications.ListApplicationsRequest;
import org.cloudfoundry.client.v3.applications.Relationships;
import org.cloudfoundry.client.v3.droplets.Droplet;
import org.cloudfoundry.client.v3.droplets.DropletResource;
import org.cloudfoundry.client.v3.droplets.GetDropletRequest;
import org.cloudfoundry.client.v3.droplets.GetDropletResponse;
import org.cloudfoundry.client.v3.droplets.StagedResult;
import org.cloudfoundry.client.v3.packages.CreatePackageRequest;
import org.cloudfoundry.client.v3.packages.GetPackageRequest;
import org.cloudfoundry.client.v3.packages.Package;
import org.cloudfoundry.client.v3.packages.PackageType;
import org.cloudfoundry.client.v3.packages.StagePackageRequest;
import org.cloudfoundry.client.v3.packages.State;
import org.cloudfoundry.client.v3.packages.UploadPackageRequest;
import org.cloudfoundry.client.v3.servicebindings.CreateServiceBindingRequest;
import org.cloudfoundry.client.v3.servicebindings.ServiceBindingType;
import org.cloudfoundry.client.v3.tasks.CancelTaskRequest;
import org.cloudfoundry.client.v3.tasks.CancelTaskResponse;
import org.cloudfoundry.client.v3.tasks.CreateTaskRequest;
import org.cloudfoundry.client.v3.tasks.CreateTaskResponse;
import org.cloudfoundry.client.v3.tasks.GetTaskRequest;
import org.cloudfoundry.client.v3.tasks.GetTaskResponse;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.services.ServiceInstance;
import org.cloudfoundry.util.DelayUtils;
import org.cloudfoundry.util.PaginationUtils;
import org.cloudfoundry.util.ResourceUtils;
import org.cloudfoundry.util.tuple.TupleUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryConnectionProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.task.LaunchState;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.deployer.spi.task.TaskStatus;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CloudFoundryTaskLauncher
implements TaskLauncher {
    private static final Logger logger = LoggerFactory.getLogger(CloudFoundryTaskLauncher.class);
    private final CloudFoundryClient client;
    private final CloudFoundryOperations operations;
    private final CloudFoundryConnectionProperties connectionProperties;
    private final CloudFoundryDeploymentProperties deploymentProperties;

    public CloudFoundryTaskLauncher(CloudFoundryClient client, CloudFoundryOperations operations, CloudFoundryConnectionProperties connectionProperties, CloudFoundryDeploymentProperties deploymentProperties) {
        this.client = client;
        this.operations = operations;
        this.connectionProperties = connectionProperties;
        this.deploymentProperties = deploymentProperties;
    }

    public void cancel(String id) {
        this.asyncCancel(id).block(Duration.ofSeconds(this.deploymentProperties.getTaskTimeout()));
    }

    public String launch(AppDeploymentRequest request) {
        return (String)this.asyncLaunch(request).block(Duration.ofSeconds(this.deploymentProperties.getTaskTimeout()));
    }

    public TaskStatus status(String id) {
        return (TaskStatus)this.asyncStatus(id).block(Duration.ofSeconds(this.deploymentProperties.getTaskTimeout()));
    }

    protected Mono<CancelTaskResponse> asyncCancel(String id) {
        return this.client.tasks().cancel(CancelTaskRequest.builder().taskId(id).build());
    }

    protected Mono<String> asyncLaunch(AppDeploymentRequest request) {
        return PaginationUtils.requestClientV3Resources(page -> this.client.applicationsV3().list(ListApplicationsRequest.builder().name(request.getDefinition().getName()).page(page).build())).singleOrEmpty().doOnError(e -> logger.error(String.format("Error obtaining app %s", request.getDefinition().getName()), e)).then(applicationResource -> this.processApplication(request, (ApplicationResource)applicationResource)).otherwiseIfEmpty(this.processApplication(request));
    }

    protected Mono<TaskStatus> asyncStatus(String id) {
        return this.client.tasks().get(GetTaskRequest.builder().taskId(id).build()).map(this::mapTaskToStatus).otherwiseIfEmpty(Mono.just((Object)new TaskStatus(id, LaunchState.unknown, null))).otherwise(throwable -> {
            logger.error(throwable.getMessage());
            return Mono.just((Object)new TaskStatus(id, LaunchState.unknown, null));
        });
    }

    protected Mono<String> processApplication(AppDeploymentRequest request, ApplicationResource resource) {
        return this.launchTask(resource.getId(), request);
    }

    protected Mono<String> processApplication(AppDeploymentRequest request) {
        return this.deploy(request).then(applicationId -> this.bindServices(request, (String)applicationId)).then(applicationId -> this.launchTask((String)applicationId, request));
    }

    protected Mono<String> bindServices(AppDeploymentRequest request, String applicationId) {
        return this.operations.services().listInstances().filter(instance -> this.servicesToBind(request).contains(instance.getName())).map(ServiceInstance::getId).flatMap(serviceInstanceId -> this.client.serviceBindingsV3().create(CreateServiceBindingRequest.builder().relationships(org.cloudfoundry.client.v3.servicebindings.Relationships.builder().application(Relationship.builder().id(applicationId).build()).serviceInstance(Relationship.builder().id(serviceInstanceId).build()).build()).type(ServiceBindingType.APPLICATION).build())).thenMany((Publisher)Mono.just((Object)applicationId)).next();
    }

    protected Mono<String> createAndUploadApplication(AppDeploymentRequest request) {
        return this.createApplication(request, this.getSpaceId(request)).then(applicationId -> this.createPackage((String)applicationId).and(Mono.just((Object)applicationId))).then(TupleUtils.function((packageId, applicationId) -> this.uploadPackage((String)packageId, request).and(Mono.just((Object)applicationId)))).then(TupleUtils.function((packageId, applicationId) -> CloudFoundryTaskLauncher.waitForPackageProcessing(this.client, packageId).and(Mono.just((Object)applicationId)))).then(TupleUtils.function((packageId, applicationId) -> this.createDroplet((String)packageId, request).and(Mono.just((Object)applicationId)))).then(TupleUtils.function((dropletId, applicationId) -> CloudFoundryTaskLauncher.waitForDropletProcessing(this.client, dropletId).and(Mono.just((Object)applicationId)))).map(TupleUtils.function((dropletId, applicationId) -> applicationId));
    }

    protected Mono<String> createApplication(AppDeploymentRequest appDeploymentRequest, Mono<String> spaceId) {
        HashMap<String, String> environmentVariables = new HashMap<String, String>(1);
        try {
            String applicationJson = new ObjectMapper().writeValueAsString((Object)appDeploymentRequest.getDefinition().getProperties());
            environmentVariables.put("SPRING_APPLICATION_JSON", applicationJson);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return spaceId.then(spaceId2 -> this.client.applicationsV3().create(CreateApplicationRequest.builder().name(appDeploymentRequest.getDefinition().getName()).environmentVariables(environmentVariables).lifecycle(Lifecycle.builder().type(Type.BUILDPACK).data((Data)BuildpackData.builder().buildpack(this.deploymentProperties.getBuildpack()).build()).build()).relationships(Relationships.builder().space(Relationship.builder().id(spaceId2).build()).build()).build())).map(Application::getId);
    }

    protected Mono<String> createPackage(String applicationId) {
        return this.client.packages().create(CreatePackageRequest.builder().applicationId(applicationId).type(PackageType.BITS).build()).map(Package::getId);
    }

    protected Mono<String> deploy(AppDeploymentRequest request) {
        return CloudFoundryTaskLauncher.getApplicationId(this.client, request.getDefinition().getName()).then(applicationId -> CloudFoundryTaskLauncher.getReadyApplicationId(this.client, applicationId)).otherwiseIfEmpty(this.createAndUploadApplication(request));
    }

    protected Mono<String> getSpaceId(AppDeploymentRequest request) {
        return this.client.organizations().list(ListOrganizationsRequest.builder().name(this.connectionProperties.getOrg()).build()).flatMap(r -> Flux.fromIterable((Iterable)r.getResources())).map(ResourceUtils::getId).flatMap(orgId -> this.client.spaces().list(ListSpacesRequest.builder().name(this.connectionProperties.getSpace()).organizationId(orgId).build())).single().flatMap(r -> Flux.fromIterable((Iterable)r.getResources())).map(ResourceUtils::getId).single();
    }

    protected Mono<String> launchTask(String applicationId, AppDeploymentRequest request) {
        return this.getDroplet(applicationId).map(DropletResource::getId).then(dropletId -> this.createTask((String)dropletId, applicationId, request));
    }

    protected Mono<String> createTask(String dropletId, String applicationId, AppDeploymentRequest request) {
        return this.client.droplets().get(GetDropletRequest.builder().dropletId(dropletId).build()).then(dropletResponse -> this.createTaskRequest((GetDropletResponse)dropletResponse, applicationId, request));
    }

    protected Mono<String> createTaskRequest(GetDropletResponse resource, String applicationId, AppDeploymentRequest request) {
        StringBuilder command = new StringBuilder((String)((StagedResult)resource.getResult()).getProcessTypes().get("web"));
        String commandLineArgs = request.getCommandlineArguments().stream().collect(Collectors.joining(" "));
        command.append(" ");
        command.append(commandLineArgs);
        return this.client.tasks().create(CreateTaskRequest.builder().applicationId(applicationId).dropletId(resource.getId()).name(request.getDefinition().getName()).command(command.toString()).build()).map(CreateTaskResponse::getId);
    }

    protected Mono<DropletResource> getDroplet(String applicationId) {
        return this.client.applicationsV3().listDroplets(ListApplicationDropletsRequest.builder().applicationId(applicationId).build()).flatMapIterable(ListApplicationDropletsResponse::getResources).single();
    }

    protected Mono<String> uploadPackage(String packageId, AppDeploymentRequest request) {
        try {
            return this.client.packages().upload(UploadPackageRequest.builder().packageId(packageId).bits(request.getResource().getInputStream()).build()).map(Package::getId);
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }

    private Set<String> servicesToBind(AppDeploymentRequest request) {
        HashSet<String> services = new HashSet<String>();
        services.addAll(this.deploymentProperties.getServices());
        services.addAll(StringUtils.commaDelimitedListToSet((String)((String)request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.services"))));
        return services;
    }

    private Mono<String> createDroplet(String packageId, AppDeploymentRequest appDeploymentRequest) {
        return this.client.packages().stage(StagePackageRequest.builder().packageId(packageId).stagingDiskInMb(Integer.valueOf(this.diskQuota(appDeploymentRequest))).stagingMemoryInMb(Integer.valueOf(this.memory(appDeploymentRequest))).build()).map(Droplet::getId);
    }

    private int diskQuota(AppDeploymentRequest request) {
        return Integer.parseInt(request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.cloudfoundry.disk", String.valueOf(this.deploymentProperties.getDisk())));
    }

    private int memory(AppDeploymentRequest request) {
        return Integer.parseInt(request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.cloudfoundry.memory", String.valueOf(this.deploymentProperties.getMemory())));
    }

    private TaskStatus mapTaskToStatus(GetTaskResponse getTaskResponse) {
        switch (getTaskResponse.getState()) {
            case SUCCEEDED_STATE: {
                return new TaskStatus(getTaskResponse.getId(), LaunchState.complete, null);
            }
            case RUNNING_STATE: {
                return new TaskStatus(getTaskResponse.getId(), LaunchState.running, null);
            }
            case PENDING_STATE: {
                return new TaskStatus(getTaskResponse.getId(), LaunchState.launching, null);
            }
            case CANCELING_STATE: {
                return new TaskStatus(getTaskResponse.getId(), LaunchState.cancelled, null);
            }
            case FAILED_STATE: {
                return new TaskStatus(getTaskResponse.getId(), LaunchState.failed, null);
            }
        }
        throw new IllegalStateException("Unsupported CF task state " + getTaskResponse.getState());
    }

    private static Mono<String> getApplicationId(CloudFoundryClient client, String name) {
        return CloudFoundryTaskLauncher.requestListApplications(client, name).singleOrEmpty().map(Application::getId);
    }

    private static Mono<String> getReadyApplicationId(CloudFoundryClient client, String applicationId) {
        return CloudFoundryTaskLauncher.requestApplicationDroplets(client, applicationId).filter(resource -> org.cloudfoundry.client.v3.droplets.State.STAGED.equals((Object)resource.getState())).single().map(resource -> applicationId);
    }

    private static Flux<DropletResource> requestApplicationDroplets(CloudFoundryClient client, String applicationId) {
        return PaginationUtils.requestClientV3Resources(page -> client.applicationsV3().listDroplets(ListApplicationDropletsRequest.builder().applicationId(applicationId).page(page).build()));
    }

    private static Mono<String> waitForDropletProcessing(CloudFoundryClient cloudFoundryClient, String dropletId) {
        return cloudFoundryClient.droplets().get(GetDropletRequest.builder().dropletId(dropletId).build()).filter(response -> !response.getState().equals((Object)org.cloudfoundry.client.v3.droplets.State.PENDING)).repeatWhenEmpty(50, DelayUtils.exponentialBackOff((Duration)Duration.ofSeconds(10L), (Duration)Duration.ofMinutes(1L), (Duration)Duration.ofMinutes(10L))).map(response -> dropletId);
    }

    private static Mono<String> waitForPackageProcessing(CloudFoundryClient cloudFoundryClient, String packageId) {
        return cloudFoundryClient.packages().get(GetPackageRequest.builder().packageId(packageId).build()).filter(response -> response.getState().equals((Object)State.READY)).repeatWhenEmpty(50, DelayUtils.exponentialBackOff((Duration)Duration.ofSeconds(5L), (Duration)Duration.ofMinutes(1L), (Duration)Duration.ofMinutes(10L))).map(response -> packageId);
    }

    private static Flux<ApplicationResource> requestListApplications(CloudFoundryClient client, String name) {
        return PaginationUtils.requestClientV3Resources(page -> client.applicationsV3().list(ListApplicationsRequest.builder().name(name).page(page).build()));
    }
}

