/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import java.util.LinkedHashMap;
import java.util.Map;
import org.cloudfoundry.operations.applications.ApplicationDetail;
import org.cloudfoundry.operations.applications.InstanceDetail;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;

public class CloudFoundryAppInstanceStatus
implements AppInstanceStatus {
    private final InstanceDetail instanceDetail;
    private final ApplicationDetail applicationDetail;
    private final int index;

    public CloudFoundryAppInstanceStatus(ApplicationDetail applicationDetail, InstanceDetail instanceDetail, int index) {
        this.applicationDetail = applicationDetail;
        this.instanceDetail = instanceDetail;
        this.index = index;
    }

    public String getId() {
        return this.applicationDetail.getName() + "-" + this.index;
    }

    public DeploymentState getState() {
        if (this.instanceDetail == null) {
            return DeploymentState.failed;
        }
        switch (this.instanceDetail.getState()) {
            case "STARTING": 
            case "DOWN": {
                return DeploymentState.deploying;
            }
            case "CRASHED": {
                return DeploymentState.failed;
            }
            case "FLAPPING": 
            case "RUNNING": {
                return DeploymentState.deployed;
            }
            case "UNKNOWN": {
                return DeploymentState.unknown;
            }
        }
        throw new IllegalStateException("Unsupported CF state " + this.instanceDetail.getState());
    }

    public Map<String, String> getAttributes() {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        if (this.instanceDetail != null) {
            if (this.instanceDetail.getCpu() != null) {
                attributes.put("cpu", String.format("%.1f%%", this.instanceDetail.getCpu() * 100.0));
            }
            if (this.instanceDetail.getDiskQuota() != null && this.instanceDetail.getDiskUsage() != null) {
                attributes.put("disk", String.format("%.1f%%", 100.0 * (double)this.instanceDetail.getDiskUsage().longValue() / (double)this.instanceDetail.getDiskQuota().longValue()));
            }
            if (this.instanceDetail.getMemoryQuota() != null && this.instanceDetail.getMemoryUsage() != null) {
                attributes.put("memory", String.format("%.1f%%", 100.0 * (double)this.instanceDetail.getMemoryUsage().longValue() / (double)this.instanceDetail.getMemoryQuota().longValue()));
            }
        }
        return attributes;
    }

    public String toString() {
        return String.format("%s[%s : %s]", this.getClass().getSimpleName(), this.getId(), this.getState());
    }
}

