/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.cloudfoundry.config;

import com.github.zafarkhaja.semver.Version;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeployerAutoConfiguration;
import org.springframework.cloud.deployer.spi.cloudfoundry.UnsupportedVersionTaskLauncher;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class TaskFeatureAutoToggleEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TaskFeatureAutoToggleEnvironmentPostProcessor.class);
    private static final String TASKS_KEY = "spring.cloud.dataflow.features.tasks-enabled";
    private static final String TASK_FEATURE_DEACTIVE_PROPERTIES = "Task Features De-activation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        try (AnnotationConfigApplicationContext applicationContext = null;){
            applicationContext = new AnnotationConfigApplicationContext();
            applicationContext.register(new Class[]{CloudFoundryDeployerAutoConfiguration.EarlyConnectionConfiguration.class});
            applicationContext.setEnvironment(environment);
            applicationContext.refresh();
            Version version = (Version)applicationContext.getBean(Version.class);
            if (version.lessThan(UnsupportedVersionTaskLauncher.MINIMUM_SUPPORTED_VERSION)) {
                logger.warn("Targeting Cloud Foundry API {}, which is incompatible with TaskLauncher support. Forcing {} to false", (Object)version, (Object)TASKS_KEY);
                environment.getPropertySources().addFirst((PropertySource)new MapPropertySource(TASK_FEATURE_DEACTIVE_PROPERTIES, Collections.singletonMap(TASKS_KEY, "false")));
            }
        }
    }
}

