/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.cloudfoundry.config.security;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.AuthoritiesExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.PrincipalExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.cloud.common.security.support.OnSecurityEnabledAndOAuth2Enabled;
import org.springframework.cloud.dataflow.server.cloudfoundry.config.security.support.CloudFoundryDataflowAuthoritiesExtractor;
import org.springframework.cloud.dataflow.server.cloudfoundry.config.security.support.CloudFoundryPrincipalExtractor;
import org.springframework.cloud.dataflow.server.cloudfoundry.config.security.support.CloudFoundrySecurityService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;

@Configuration
@Conditional(value={OnSecurityEnabledAndOAuth2Enabled.class})
@ConditionalOnCloudPlatform(value=CloudPlatform.CLOUD_FOUNDRY)
@Import(value={CloudFoundryUAAConfiguration.class})
public class CloudFoundryOAuthSecurityConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CloudFoundryOAuthSecurityConfiguration.class);
    @Autowired
    private UserInfoTokenServices userInfoTokenServices;
    @Autowired(required=false)
    private CloudFoundryDataflowAuthoritiesExtractor cloudFoundryDataflowAuthoritiesExtractor;
    @Autowired(required=false)
    private PrincipalExtractor principalExtractor;

    @PostConstruct
    public void init() {
        if (this.cloudFoundryDataflowAuthoritiesExtractor != null) {
            logger.info("Setting up Cloud Foundry AuthoritiesExtractor for UAA.");
            this.userInfoTokenServices.setAuthoritiesExtractor((AuthoritiesExtractor)this.cloudFoundryDataflowAuthoritiesExtractor);
        }
        if (this.principalExtractor != null) {
            logger.info("Setting up Cloud Foundry PrincipalExtractor.");
            this.userInfoTokenServices.setPrincipalExtractor(this.principalExtractor);
        } else {
            this.userInfoTokenServices.setPrincipalExtractor((PrincipalExtractor)new CloudFoundryPrincipalExtractor());
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"spring.cloud.dataflow.security.cf-use-uaa"}, havingValue="true")
    public class CloudFoundryUAAConfiguration {
        @Value(value="${vcap.application.cf_api}")
        private String cloudControllerUrl;
        @Value(value="${vcap.application.application_id}")
        private String applicationId;
        @Autowired
        private OAuth2RestTemplate oAuth2RestTemplate;

        @Bean
        public CloudFoundryDataflowAuthoritiesExtractor authoritiesExtractor() {
            return new CloudFoundryDataflowAuthoritiesExtractor(this.cloudFoundrySecurityService());
        }

        @Bean
        public CloudFoundrySecurityService cloudFoundrySecurityService() {
            return new CloudFoundrySecurityService(this.oAuth2RestTemplate, this.cloudControllerUrl, this.applicationId);
        }
    }
}

