/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.cloudfoundry.config;

import java.io.File;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.dataflow.server.cloudfoundry.config.CloudFoundryServerConfigurationProperties;
import org.springframework.cloud.dataflow.server.cloudfoundry.config.security.CloudFoundryOAuthSecurityConfiguration;
import org.springframework.cloud.dataflow.server.cloudfoundry.resource.LRUCleaningResourceLoaderBeanPostProcessor;
import org.springframework.cloud.deployer.resource.docker.DockerResource;
import org.springframework.cloud.deployer.resource.docker.DockerResourceLoader;
import org.springframework.cloud.deployer.resource.maven.MavenProperties;
import org.springframework.cloud.deployer.resource.maven.MavenResource;
import org.springframework.cloud.deployer.resource.maven.MavenResourceLoader;
import org.springframework.cloud.deployer.resource.support.DelegatingResourceLoader;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import reactor.core.publisher.Hooks;

@Configuration
@Import(value={CloudFoundryOAuthSecurityConfiguration.class})
public class CloudFoundryDataFlowServerConfiguration {
    @Bean
    @ConfigurationProperties(prefix="spring.cloud.deployer.cloudfoundry.stream")
    public CloudFoundryDeploymentProperties appDeploymentProperties() {
        return new CloudFoundryDeploymentProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="spring.cloud.deployer.cloudfoundry.task")
    public CloudFoundryDeploymentProperties taskDeploymentProperties() {
        return new CloudFoundryDeploymentProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="spring.cloud.dataflow.server.cloudfoundry")
    public CloudFoundryServerConfigurationProperties cloudFoundryServerConfigurationProperties() {
        return new CloudFoundryServerConfigurationProperties();
    }

    @Bean
    public DelegatingResourceLoader delegatingResourceLoader(MavenProperties mavenProperties) {
        HashMap<String, Object> loaders = new HashMap<String, Object>();
        loaders.put(DockerResource.URI_SCHEME, new DockerResourceLoader());
        loaders.put(MavenResource.URI_SCHEME, new MavenResourceLoader(mavenProperties));
        return new DelegatingResourceLoader(loaders);
    }

    @Bean
    public LRUCleaningResourceLoaderBeanPostProcessor lruCleaningResourceLoaderInstaller(CloudFoundryServerConfigurationProperties serverConfiguration, MavenProperties mavenProperties) {
        File repositoryCache = new File(mavenProperties.getLocalRepository());
        float fRatio = (float)serverConfiguration.getFreeDiskSpacePercentage() / 100.0f;
        return new LRUCleaningResourceLoaderBeanPostProcessor(fRatio, repositoryCache);
    }

    @PostConstruct
    public void afterPropertiesSet() {
        if (this.cloudFoundryServerConfigurationProperties().isDebugReactor()) {
            Hooks.onOperator(op -> op.operatorStacktrace());
        }
    }
}

