/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.util;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.dataflow.core.TaskManifest;
import org.springframework.cloud.dataflow.rest.util.ArgumentSanitizer;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.task.repository.TaskExecution;

public class TaskSanitizer {
    private ArgumentSanitizer argumentSanitizer = new ArgumentSanitizer();

    public TaskExecution sanitizeTaskExecutionArguments(TaskExecution taskExecution) {
        List args = taskExecution.getArguments().stream().map(argument -> this.argumentSanitizer.sanitize((String)argument)).collect(Collectors.toList());
        taskExecution.setArguments(args);
        return taskExecution;
    }

    public TaskManifest sanitizeTaskManifest(TaskManifest taskManifest) {
        if (taskManifest == null) {
            return null;
        }
        TaskManifest sanitizedTaskManifest = new TaskManifest();
        sanitizedTaskManifest.setPlatformName(taskManifest.getPlatformName());
        AppDeploymentRequest existingAppDeploymentRequest = taskManifest.getTaskDeploymentRequest();
        Map existingAppProperties = existingAppDeploymentRequest.getDefinition().getProperties();
        Map<String, String> sanitizedAppProperties = this.argumentSanitizer.sanitizeProperties(existingAppProperties);
        Map existingDeploymentProperties = existingAppDeploymentRequest.getDeploymentProperties();
        Map<String, String> sanitizedDeploymentProperties = this.argumentSanitizer.sanitizeProperties(existingDeploymentProperties);
        AppDefinition sanitizedAppDefinition = new AppDefinition(existingAppDeploymentRequest.getDefinition().getName(), sanitizedAppProperties);
        List sanitizedCommandLineArgs = existingAppDeploymentRequest.getCommandlineArguments().stream().map(argument -> this.argumentSanitizer.sanitize((String)argument)).collect(Collectors.toList());
        AppDeploymentRequest sanitizedAppDeploymentRequest = new AppDeploymentRequest(sanitizedAppDefinition, existingAppDeploymentRequest.getResource(), sanitizedDeploymentProperties, sanitizedCommandLineArgs);
        sanitizedTaskManifest.setTaskDeploymentRequest(sanitizedAppDeploymentRequest);
        return sanitizedTaskManifest;
    }
}

