/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.cloud.dataflow.core.DefinitionUtils;
import org.springframework.cloud.dataflow.core.TaskDefinition;
import org.springframework.cloud.dataflow.core.dsl.TaskParser;
import org.springframework.cloud.dataflow.core.dsl.graph.Graph;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ArgumentSanitizer {
    private static final Logger logger = LoggerFactory.getLogger(ArgumentSanitizer.class);
    private static final String[] REGEX_PARTS = new String[]{"*", "$", "^", "+"};
    private static final String REDACTION_STRING = "******";
    private static final String[] KEYS_TO_SANITIZE = new String[]{"username", "password", "secret", "key", "token", ".*credentials.*", "vcap_services", "url"};
    private static final TypeReference<Map<String, Object>> mapTypeReference = new TypeReference<Map<String, Object>>(){};
    private final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private Pattern[] keysToSanitize = new Pattern[KEYS_TO_SANITIZE.length];

    public ArgumentSanitizer() {
        for (int i = 0; i < this.keysToSanitize.length; ++i) {
            this.keysToSanitize[i] = this.getPattern(KEYS_TO_SANITIZE[i]);
        }
    }

    private Pattern getPattern(String value) {
        if (this.isRegex(value)) {
            return Pattern.compile(value, 2);
        }
        return Pattern.compile(".*" + value + "$", 2);
    }

    private boolean isRegex(String value) {
        for (String part : REGEX_PARTS) {
            if (!value.contains(part)) continue;
            return true;
        }
        return false;
    }

    public String sanitize(String argument) {
        if (argument == null) {
            return "";
        }
        int indexOfFirstEqual = argument.indexOf("=");
        if (indexOfFirstEqual == -1) {
            return argument;
        }
        String key = argument.substring(0, indexOfFirstEqual);
        String value = argument.substring(indexOfFirstEqual + 1);
        value = this.sanitize(key, value);
        return String.format("%s=%s", key, value);
    }

    public String sanitize(String key, String value) {
        if (StringUtils.hasText((String)value)) {
            for (Pattern pattern : this.keysToSanitize) {
                if (!pattern.matcher(key).matches()) continue;
                value = REDACTION_STRING;
                break;
            }
        }
        return value;
    }

    public JobParameters sanitizeJobParameters(JobParameters jobParameters) {
        HashMap newJobParameters = new HashMap();
        jobParameters.getParameters().forEach((key, jobParameter) -> {
            String updatedKey;
            String string = updatedKey = !jobParameter.isIdentifying() ? "-" + key : key;
            if (jobParameter.getType().equals((Object)JobParameter.ParameterType.STRING)) {
                newJobParameters.put(updatedKey, new JobParameter(this.sanitize((String)key, jobParameter.toString())));
            } else {
                newJobParameters.put(updatedKey, jobParameter);
            }
        });
        return new JobParameters(newJobParameters);
    }

    public String sanitizeTaskDsl(TaskDefinition taskDefinition) {
        if (StringUtils.isEmpty((Object)taskDefinition.getDslText())) {
            return taskDefinition.getDslText();
        }
        TaskParser taskParser = new TaskParser(taskDefinition.getTaskName(), taskDefinition.getDslText(), true, true);
        Graph graph = taskParser.parse().toGraph();
        graph.getNodes().stream().forEach(node -> {
            if (node.properties != null) {
                node.properties.keySet().stream().forEach(key -> node.properties.put(key, DefinitionUtils.autoQuotes((String)this.sanitize((String)key, (String)node.properties.get(key)))));
            }
        });
        return graph.toDSLText();
    }

    public Map<String, String> sanitizeProperties(Map<String, String> properties) {
        if (!CollectionUtils.isEmpty(properties)) {
            LinkedHashMap<String, String> sanitizedProperties = new LinkedHashMap<String, String>(properties.size());
            for (Map.Entry<String, String> property : properties.entrySet()) {
                sanitizedProperties.put(property.getKey(), this.sanitize(property.getKey(), property.getValue()));
            }
            return sanitizedProperties;
        }
        return properties;
    }

    public List<String> sanitizeArguments(List<String> arguments) {
        if (!CollectionUtils.isEmpty(arguments)) {
            ArrayList<String> sanitizedArguments = new ArrayList<String>(arguments.size());
            for (String argument : arguments) {
                sanitizedArguments.add(this.sanitize(argument));
            }
            return sanitizedArguments;
        }
        return arguments;
    }

    public HttpHeaders sanitizeHeaders(HttpHeaders headers) {
        HttpHeaders result = new HttpHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            List values = (List)entry.getValue();
            for (String value : values) {
                result.add((String)entry.getKey(), this.sanitize((String)entry.getKey(), value));
            }
        }
        return result;
    }

    public Map<String, Object> sanitizeMap(Map<String, Object> input) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            if (entry.getValue() instanceof String) {
                result.put(entry.getKey(), this.sanitize(entry.getKey(), (String)entry.getValue()));
                continue;
            }
            if (entry.getValue() instanceof Map) {
                Map map = (Map)entry.getValue();
                result.put(entry.getKey(), this.sanitizeMap(map));
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public String sanitizeJsonString(String input) throws JsonProcessingException {
        if (input == null) {
            return null;
        }
        Map data = (Map)this.jsonMapper.readValue(input, mapTypeReference);
        return this.jsonMapper.writeValueAsString(this.sanitizeMap(data));
    }

    public String sanitizeYamlString(String input) throws JsonProcessingException {
        if (input == null) {
            return null;
        }
        Map data = (Map)this.yamlMapper.readValue(input, mapTypeReference);
        return this.yamlMapper.writeValueAsString(this.sanitizeMap(data));
    }

    public String sanitizeJsonOrYamlString(String input) {
        if (input == null) {
            return null;
        }
        try {
            return this.sanitizeJsonString(input);
        }
        catch (Throwable x) {
            logger.trace("Cannot parse as JSON:" + x);
            try {
                return this.sanitizeYamlString(input);
            }
            catch (Throwable x2) {
                logger.trace("Cannot parse as YAML:" + x2);
                if (input.contains("\n")) {
                    return StringUtils.collectionToDelimitedString(this.sanitizeArguments(Arrays.asList(StringUtils.split((String)input, (String)"\n"))), (String)"\n");
                }
                if (input.contains("--")) {
                    return StringUtils.collectionToDelimitedString(this.sanitizeArguments(Arrays.asList(StringUtils.split((String)input, (String)"--"))), (String)"--");
                }
                return this.sanitize(input);
            }
        }
    }
}

