/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.resource;

import java.util.Date;
import org.springframework.cloud.dataflow.rest.resource.TaskExecutionStatus;
import org.springframework.cloud.dataflow.schema.AggregateTaskExecution;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.util.StringUtils;

public class TaskExecutionThinResource
extends RepresentationModel<TaskExecutionThinResource> {
    private long executionId;
    private Long parentExecutionId;
    private Integer exitCode;
    private String taskName;
    private Date startTime;
    private Date endTime;
    private String exitMessage;
    private String externalExecutionId;
    private String errorMessage;
    private String taskExecutionStatus;
    private String composedTaskJobExecutionStatus;
    private String schemaTarget;

    public TaskExecutionThinResource() {
    }

    public TaskExecutionThinResource(AggregateTaskExecution aggregateTaskExecution) {
        this.executionId = aggregateTaskExecution.getExecutionId();
        this.schemaTarget = aggregateTaskExecution.getSchemaTarget();
        this.taskName = aggregateTaskExecution.getTaskName();
        this.externalExecutionId = aggregateTaskExecution.getExternalExecutionId();
        this.parentExecutionId = aggregateTaskExecution.getParentExecutionId();
        this.startTime = aggregateTaskExecution.getStartTime();
        this.endTime = aggregateTaskExecution.getEndTime();
        this.exitCode = aggregateTaskExecution.getExitCode();
        this.exitMessage = aggregateTaskExecution.getExitMessage();
        this.errorMessage = aggregateTaskExecution.getErrorMessage();
        this.composedTaskJobExecutionStatus = aggregateTaskExecution.getCtrTaskStatus();
    }

    public long getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(long executionId) {
        this.executionId = executionId;
    }

    public Long getParentExecutionId() {
        return this.parentExecutionId;
    }

    public void setParentExecutionId(Long parentExecutionId) {
        this.parentExecutionId = parentExecutionId;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getExitMessage() {
        return this.exitMessage;
    }

    public void setExitMessage(String exitMessage) {
        this.exitMessage = exitMessage;
    }

    public String getExternalExecutionId() {
        return this.externalExecutionId;
    }

    public void setExternalExecutionId(String externalExecutionId) {
        this.externalExecutionId = externalExecutionId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getSchemaTarget() {
        return this.schemaTarget;
    }

    public void setSchemaTarget(String schemaTarget) {
        this.schemaTarget = schemaTarget;
    }

    public void setTaskExecutionStatus(String taskExecutionStatus) {
        this.taskExecutionStatus = taskExecutionStatus;
    }

    public TaskExecutionStatus getTaskExecutionStatus() {
        if (StringUtils.hasText((String)this.taskExecutionStatus)) {
            return TaskExecutionStatus.valueOf(this.taskExecutionStatus);
        }
        if (this.startTime == null) {
            return TaskExecutionStatus.UNKNOWN;
        }
        if (this.endTime == null) {
            return TaskExecutionStatus.RUNNING;
        }
        if (this.composedTaskJobExecutionStatus != null) {
            return this.composedTaskJobExecutionStatus.equals("ABANDONED") || this.composedTaskJobExecutionStatus.equals("FAILED") || this.composedTaskJobExecutionStatus.equals("STOPPED") ? TaskExecutionStatus.ERROR : TaskExecutionStatus.COMPLETE;
        }
        return this.exitCode == null ? TaskExecutionStatus.RUNNING : (this.exitCode == 0 ? TaskExecutionStatus.COMPLETE : TaskExecutionStatus.ERROR);
    }

    public static class Page
    extends PagedModel<TaskExecutionThinResource> {
    }
}

