/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.job;

import org.springframework.batch.core.JobExecution;
import org.springframework.util.Assert;

public class TaskJobExecution {
    private final long taskId;
    private final boolean isTaskDefined;
    private final JobExecution jobExecution;
    private final int stepExecutionCount;
    private final String schemaTarget;

    public TaskJobExecution(long taskId, JobExecution jobExecution, boolean isTaskDefined, String schemaTarget) {
        this(taskId, jobExecution, isTaskDefined, 0, schemaTarget);
    }

    public TaskJobExecution(long taskId, JobExecution jobExecution, boolean isTaskDefined, int stepExecutionCount, String schemaTarget) {
        Assert.notNull((Object)jobExecution, (String)"jobExecution must not be null");
        this.taskId = taskId;
        this.jobExecution = jobExecution;
        this.isTaskDefined = isTaskDefined;
        this.stepExecutionCount = stepExecutionCount;
        this.schemaTarget = schemaTarget;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public JobExecution getJobExecution() {
        return this.jobExecution;
    }

    public boolean isTaskDefined() {
        return this.isTaskDefined;
    }

    public int getStepExecutionCount() {
        return this.stepExecutionCount;
    }

    public String getSchemaTarget() {
        return this.schemaTarget;
    }

    public String toString() {
        return "TaskJobExecution{taskId=" + this.taskId + ", isTaskDefined=" + this.isTaskDefined + ", jobExecution=" + this.jobExecution + ", stepExecutionCount=" + this.stepExecutionCount + ", schemaTarget='" + this.schemaTarget + '\'' + '}';
    }
}

